/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter;

import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.server.authorization.annotations.IcebergAuthorizationMetadata;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionEvaluator;
import org.apache.gravitino.server.web.filter.BaseMetadataAuthorizationMethodInterceptor;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.rest.requests.RenameTableRequest;

public class RenameTableAuthzHandler
implements BaseMetadataAuthorizationMethodInterceptor.AuthorizationHandler {
    private final Parameter[] parameters;
    private final Object[] args;
    private boolean crossNamespaceRename = false;

    public RenameTableAuthzHandler(Parameter[] parameters, Object[] args) {
        this.parameters = parameters;
        this.args = args;
    }

    @Override
    public void process(Map<Entity.EntityType, NameIdentifier> nameIdentifierMap) {
        RenameTableRequest renameTableRequest = null;
        for (int i = 0; i < this.parameters.length; ++i) {
            IcebergAuthorizationMetadata metadata = this.parameters[i].getAnnotation(IcebergAuthorizationMetadata.class);
            if (metadata == null || metadata.type() != IcebergAuthorizationMetadata.RequestType.RENAME_TABLE) continue;
            renameTableRequest = (RenameTableRequest)this.args[i];
            break;
        }
        if (renameTableRequest == null) {
            throw new ForbiddenException("RenameTableRequest not found in parameters", new Object[0]);
        }
        NameIdentifier metalakeIdent = nameIdentifierMap.get(Entity.EntityType.METALAKE);
        NameIdentifier catalogIdent = nameIdentifierMap.get(Entity.EntityType.CATALOG);
        if (metalakeIdent == null || catalogIdent == null) {
            throw new ForbiddenException("Missing metalake or catalog context for authorization", new Object[0]);
        }
        String metalakeName = metalakeIdent.name();
        String catalog = catalogIdent.name();
        String sourceSchema = renameTableRequest.source().namespace().level(0);
        String sourceTable = renameTableRequest.source().name();
        nameIdentifierMap.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.ofSchema((String)metalakeName, (String)catalog, (String)sourceSchema));
        nameIdentifierMap.put(Entity.EntityType.TABLE, NameIdentifierUtil.ofTable((String)metalakeName, (String)catalog, (String)sourceSchema, (String)sourceTable));
        String destSchema = renameTableRequest.destination().namespace().level(0);
        if (!sourceSchema.equals(destSchema)) {
            this.crossNamespaceRename = true;
            this.validateCrossNamespaceRename(catalog, metalakeName, sourceSchema, sourceTable, destSchema);
        }
    }

    @Override
    public boolean authorizationCompleted() {
        return this.crossNamespaceRename;
    }

    private void validateCrossNamespaceRename(String catalog, String metalakeName, String sourceSchema, String sourceTable, String destSchema) {
        String currentUser = PrincipalUtils.getCurrentUserName();
        HashMap<Entity.EntityType, NameIdentifier> sourceContext = new HashMap<Entity.EntityType, NameIdentifier>();
        sourceContext.put(Entity.EntityType.METALAKE, NameIdentifierUtil.ofMetalake((String)metalakeName));
        sourceContext.put(Entity.EntityType.CATALOG, NameIdentifierUtil.ofCatalog((String)metalakeName, (String)catalog));
        sourceContext.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.ofSchema((String)metalakeName, (String)catalog, (String)sourceSchema));
        sourceContext.put(Entity.EntityType.TABLE, NameIdentifierUtil.ofTable((String)metalakeName, (String)catalog, (String)sourceSchema, (String)sourceTable));
        String sourceExpression = "ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA && TABLE::OWNER";
        AuthorizationExpressionEvaluator sourceEvaluator = new AuthorizationExpressionEvaluator(sourceExpression);
        boolean sourceAuthorized = sourceEvaluator.evaluate(sourceContext, new HashMap(), new AuthorizationRequestContext(), Optional.empty());
        if (!sourceAuthorized) {
            String notAuthzMessage = String.format("User '%s' is not authorized to drop/move table '%s' from schema '%s'. Only the table owner can move a table to a different schema.", currentUser, sourceTable, sourceSchema);
            throw new ForbiddenException(notAuthzMessage, new Object[0]);
        }
        HashMap<Entity.EntityType, NameIdentifier> destContext = new HashMap<Entity.EntityType, NameIdentifier>();
        destContext.put(Entity.EntityType.METALAKE, NameIdentifierUtil.ofMetalake((String)metalakeName));
        destContext.put(Entity.EntityType.CATALOG, NameIdentifierUtil.ofCatalog((String)metalakeName, (String)catalog));
        destContext.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.ofSchema((String)metalakeName, (String)catalog, (String)destSchema));
        String destExpression = "ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA && ANY_CREATE_TABLE";
        AuthorizationExpressionEvaluator destEvaluator = new AuthorizationExpressionEvaluator(destExpression);
        boolean destAuthorized = destEvaluator.evaluate(destContext, new HashMap(), new AuthorizationRequestContext(), Optional.empty());
        if (!destAuthorized) {
            String notAuthzMessage = String.format("User '%s' is not authorized to create table in destination schema '%s'", currentUser, destSchema);
            throw new ForbiddenException(notAuthzMessage, new Object[0]);
        }
    }
}

