/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.parser;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.exception.ExpressionSyntaxErrorException;
import com.googlecode.aviator.exception.UnsupportedFeatureException;
import com.googlecode.aviator.lexer.ExpressionLexer;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.CharToken;
import com.googlecode.aviator.lexer.token.DelegateToken;
import com.googlecode.aviator.lexer.token.NumberToken;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.lexer.token.PatternToken;
import com.googlecode.aviator.lexer.token.StringToken;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.parser.CompileTypes;
import com.googlecode.aviator.parser.DepthState;
import com.googlecode.aviator.parser.Parser;
import com.googlecode.aviator.parser.ScopeInfo;
import com.googlecode.aviator.runtime.FunctionArgument;
import com.googlecode.aviator.runtime.FunctionParam;
import com.googlecode.aviator.utils.Constants;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Set;

public class ExpressionParser
implements Parser {
    private final ExpressionLexer lexer;
    private Token<?> lookhead;
    private final ArrayDeque<Token<?>> prevTokens = new ArrayDeque();
    private CodeGenerator codeGenerator;
    private ScopeInfo scope = new ScopeInfo(0, 0, 0, 0, false, new ArrayDeque<DepthState>());
    private int parsedTokens;
    private boolean inPattern = false;
    private final AviatorEvaluatorInstance instance;
    private final boolean captureFuncArgs;
    private final Set<Feature> featureSet;
    public static final CharToken LEFT_PAREN = new CharToken('(', 0, -1);
    public static final CharToken RIGHT_PAREN = new CharToken(')', 0, -1);
    private int getCGTimes;

    public Token<?> getPrevToken() {
        return this.prevTokens.peek();
    }

    @Override
    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public Token<?> getLookhead() {
        return this.lookhead;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.lexer.getSymbolTable();
    }

    @Override
    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    @Override
    public ScopeInfo enterScope(boolean inNewScope) {
        ScopeInfo current = this.scope;
        this.scope = new ScopeInfo(0, 0, 0, 0, inNewScope, new ArrayDeque<DepthState>());
        return current;
    }

    @Override
    public void restoreScope(ScopeInfo info) {
        this.scope = info;
    }

    public ExpressionParser(AviatorEvaluatorInstance instance, ExpressionLexer lexer, CodeGenerator codeGenerator) {
        this.instance = instance;
        this.captureFuncArgs = instance.getOptionValue((Options)Options.CAPTURE_FUNCTION_ARGS).bool;
        this.lexer = lexer;
        this.lookhead = this.lexer.scan();
        if (this.lookhead != null) {
            ++this.parsedTokens;
        }
        this.featureSet = this.instance.getOptionValue((Options)Options.FEATURE_SET).featureSet;
        if (this.lookhead == null) {
            this.reportSyntaxError("blank script");
        }
        this.setCodeGenerator(codeGenerator);
        this.getCodeGeneratorWithTimes().setParser(this);
    }

    private void ensureFeatureEnabled(Feature feature) {
        if (!this.featureSet.contains((Object)feature)) {
            throw new UnsupportedFeatureException(feature);
        }
    }

    public void returnStatement() {
        this.move(true);
        CodeGenerator cg = this.getCodeGeneratorWithTimes();
        cg.onTernaryEnd(this.lookhead);
        if (this.expectChar(';')) {
            if (this.scope.newLexicalScope) {
                cg.onMethodName(Constants.ReducerReturnFn);
                cg.onConstant(Variable.NIL);
                cg.onMethodParameter(this.lookhead);
                cg.onMethodInvoke(this.lookhead);
            } else {
                cg.onConstant(Variable.NIL);
            }
            this.move(true);
            return;
        }
        if (this.scope.newLexicalScope) {
            cg.onMethodName(Constants.ReducerReturnFn);
            if (!this.ternary()) {
                this.reportSyntaxError("invalid value for return, missing ';'?");
            }
            cg.onMethodParameter(this.lookhead);
            cg.onMethodInvoke(this.lookhead);
        } else if (!this.ternary()) {
            this.reportSyntaxError("invalid value for return, missing ';'?");
        }
        if (!this.expectChar(';')) {
            this.reportSyntaxError("missing ';' for return statement");
        }
        this.move(true);
    }

    public boolean ternary() {
        int gcTimes = this.getCGTimes;
        if (this.lookhead == Variable.NEW) {
            this.newStatement();
            return true;
        }
        this.join();
        if (this.lookhead == null || this.expectChar(':') || this.expectChar(',')) {
            return gcTimes < this.getCGTimes;
        }
        Token<?> opToken = this.lookhead;
        if (this.expectChar('?')) {
            this.move(true);
            CodeGenerator cg = this.getCodeGeneratorWithTimes();
            cg.onTernaryBoolean(opToken);
            if (!this.ternary()) {
                this.reportSyntaxError("invalid token for ternary operator");
            }
            if (this.expectChar(':')) {
                this.move(true);
                cg.onTernaryLeft(this.lookhead);
                if (!this.ternary()) {
                    this.reportSyntaxError("invalid token for ternary operator");
                }
                cg.onTernaryRight(this.lookhead);
            } else {
                this.reportSyntaxError("expect ':'");
            }
        }
        return gcTimes < this.getCGTimes;
    }

    public void join() {
        this.and();
        while (true) {
            Token<?> opToken = this.lookhead;
            if (this.expectChar('|')) {
                this.getCodeGeneratorWithTimes().onJoinLeft(opToken);
                this.move(true);
                if (this.expectChar('|')) {
                    this.move(true);
                    this.and();
                    this.getCodeGeneratorWithTimes().onJoinRight(opToken);
                    continue;
                }
                this.reportSyntaxError("expect '|'");
                continue;
            }
            String alias = this.instance.getOperatorAliasToken(OperatorType.OR);
            if (alias == null || opToken == null || opToken.getType() != Token.TokenType.Variable || !opToken.getLexeme().equals(alias)) break;
            CodeGenerator cg = this.getCodeGeneratorWithTimes();
            cg.onJoinLeft(opToken);
            this.move(true);
            this.and();
            cg.onJoinRight(opToken);
        }
    }

    private boolean expectChar(char ch) {
        if (this.lookhead == null) {
            return false;
        }
        return this.lookhead.getType() == Token.TokenType.Char && ((CharToken)this.lookhead).getCh() == ch;
    }

    public void bitOr() {
        this.xor();
        while (true) {
            Token<?> opToken = this.lookhead;
            if (!this.expectChar('|')) break;
            this.move(true);
            if (this.expectChar('|')) {
                this.back();
                break;
            }
            this.xor();
            this.getCodeGeneratorWithTimes().onBitOr(opToken);
        }
    }

    public void xor() {
        this.bitAnd();
        while (true) {
            Token<?> opToken = this.lookhead;
            if (!this.expectChar('^')) break;
            this.move(true);
            this.bitAnd();
            this.getCodeGeneratorWithTimes().onBitXor(opToken);
        }
    }

    public void bitAnd() {
        this.equality();
        while (true) {
            Token<?> opToken = this.lookhead;
            if (!this.expectChar('&')) break;
            this.move(true);
            if (this.expectChar('&')) {
                this.back();
                break;
            }
            this.equality();
            this.getCodeGeneratorWithTimes().onBitAnd(opToken);
        }
    }

    public void and() {
        this.bitOr();
        while (true) {
            Token<?> opToken = this.lookhead;
            if (this.expectChar('&')) {
                CodeGenerator cg = this.getCodeGeneratorWithTimes();
                cg.onAndLeft(opToken);
                this.move(true);
                if (this.expectChar('&')) {
                    this.move(true);
                    this.bitOr();
                    cg.onAndRight(opToken);
                    continue;
                }
                this.reportSyntaxError("expect '&'");
                continue;
            }
            String alias = this.instance.getOperatorAliasToken(OperatorType.AND);
            if (alias == null || opToken == null || opToken.getType() != Token.TokenType.Variable || !opToken.getLexeme().equals(alias)) break;
            CodeGenerator cg = this.getCodeGeneratorWithTimes();
            cg.onAndLeft(opToken);
            this.move(true);
            this.bitOr();
            cg.onAndRight(opToken);
        }
    }

    public void equality() {
        this.rel();
        while (true) {
            Token<?> opToken = this.lookhead;
            Token<?> prevToken = this.getPrevToken();
            if (this.expectChar('=')) {
                this.move(true);
                if (this.expectChar('=')) {
                    this.move(true);
                    this.rel();
                    this.getCodeGeneratorWithTimes().onEq(opToken);
                    continue;
                }
                if (this.expectChar('~')) {
                    this.move(true);
                    this.rel();
                    this.getCodeGeneratorWithTimes().onMatch(opToken);
                    continue;
                }
                boolean isVar = false;
                if (prevToken.getType() == Token.TokenType.Variable) {
                    isVar = true;
                } else if (prevToken.getType() == Token.TokenType.Char && ((CharToken)prevToken).getCh() == ']') {
                    int depth = 1;
                    boolean beginSearch = false;
                    boolean found = false;
                    for (Token<?> t : this.prevTokens) {
                        if (!beginSearch && t == prevToken) {
                            beginSearch = true;
                            continue;
                        }
                        if (beginSearch && t.getType() == Token.TokenType.Char) {
                            CharToken chToken = (CharToken)t;
                            switch (chToken.getCh()) {
                                case ']': {
                                    ++depth;
                                    break;
                                }
                                case '[': {
                                    --depth;
                                }
                            }
                            if (depth == 0) {
                                found = true;
                                continue;
                            }
                        }
                        if (!found) continue;
                        if (t.getType() != Token.TokenType.Variable) break;
                        t.withMeta("type", CompileTypes.Array);
                        break;
                    }
                }
                StatementType stmtType = this.statement();
                if (isVar) {
                    this.checkVarIsInit(prevToken, stmtType);
                }
                this.ensureFeatureEnabled(Feature.Assignment);
                this.getCodeGeneratorWithTimes().onAssignment(opToken);
                continue;
            }
            if (!this.expectChar('!')) break;
            this.move(true);
            if (this.expectChar('=')) {
                this.move(true);
                this.rel();
                this.getCodeGeneratorWithTimes().onNeq(opToken);
                continue;
            }
            this.reportSyntaxError("expect '='");
        }
    }

    private void checkVarIsInit(Token<?> prevToken, StatementType stmtType) {
        boolean isInit = true;
        for (Token<?> t : this.prevTokens) {
            if (t == prevToken) break;
            if (t.getType() != Token.TokenType.Variable || !t.getLexeme().equals(prevToken.getLexeme())) continue;
            isInit = false;
            break;
        }
        prevToken.withMeta("isInitialized", isInit);
    }

    public void rel() {
        this.shift();
        while (true) {
            Token<?> opToken = this.lookhead;
            if (this.expectChar('<')) {
                this.move(true);
                if (this.expectChar('=')) {
                    this.move(true);
                    this.expr();
                    this.getCodeGeneratorWithTimes().onLe(opToken);
                    continue;
                }
                this.expr();
                this.getCodeGeneratorWithTimes().onLt(opToken);
                continue;
            }
            if (!this.expectChar('>')) break;
            this.move(true);
            if (this.expectChar('=')) {
                this.move(true);
                this.expr();
                this.getCodeGeneratorWithTimes().onGe(opToken);
                continue;
            }
            this.expr();
            this.getCodeGeneratorWithTimes().onGt(opToken);
        }
    }

    public void shift() {
        block4: {
            this.expr();
            while (true) {
                Token<?> opToken = this.lookhead;
                if (this.expectChar('<')) {
                    this.move(true);
                    if (this.expectChar('<')) {
                        this.move(true);
                        this.expr();
                        this.getCodeGeneratorWithTimes().onShiftLeft(opToken);
                        continue;
                    }
                    this.back();
                    break block4;
                }
                if (!this.expectChar('>')) break block4;
                this.move(true);
                if (!this.expectChar('>')) break;
                this.move(true);
                if (this.expectChar('>')) {
                    this.move(true);
                    this.expr();
                    this.getCodeGeneratorWithTimes().onUnsignedShiftRight(opToken);
                    continue;
                }
                this.expr();
                this.getCodeGeneratorWithTimes().onShiftRight(opToken);
            }
            this.back();
        }
    }

    public void expr() {
        this.term();
        while (true) {
            Token<?> opToken = this.lookhead;
            if (this.expectChar('+')) {
                this.move(true);
                this.term();
                this.getCodeGeneratorWithTimes().onAdd(opToken);
                continue;
            }
            if (!this.expectChar('-')) break;
            this.move(true);
            this.term();
            this.getCodeGeneratorWithTimes().onSub(opToken);
        }
    }

    public void exponent() {
        block1: {
            this.factor();
            while (true) {
                Token<?> opToken = this.lookhead;
                if (!this.expectChar('*')) break block1;
                this.move(true);
                if (!this.expectChar('*')) break;
                this.move(true);
                this.unary();
                this.getCodeGeneratorWithTimes().onExponent(opToken);
            }
            this.back();
        }
    }

    public void term() {
        this.unary();
        while (true) {
            Token<?> opToken = this.lookhead;
            if (this.expectChar('*')) {
                this.move(true);
                this.unary();
                this.getCodeGeneratorWithTimes().onMult(opToken);
                continue;
            }
            if (this.expectChar('/')) {
                this.move(true);
                this.unary();
                this.getCodeGeneratorWithTimes().onDiv(opToken);
                continue;
            }
            if (!this.expectChar('%')) break;
            this.move(true);
            this.unary();
            this.getCodeGeneratorWithTimes().onMod(opToken);
        }
    }

    public void unary() {
        Token<?> opToken = this.lookhead;
        if (this.expectChar('!')) {
            this.move(true);
            if (this.expectChar(',') || this.expectChar(')')) {
                this.back();
                this.exponent();
            } else {
                this.unary();
                this.getCodeGeneratorWithTimes().onNot(opToken);
            }
        } else if (this.expectChar('-')) {
            this.move(true);
            if (this.expectChar(',') || this.expectChar(')')) {
                this.back();
                this.exponent();
            } else {
                this.unary();
                this.getCodeGeneratorWithTimes().onNeg(opToken);
            }
        } else if (this.expectChar('~')) {
            this.move(true);
            if (this.expectChar(',') || this.expectChar(')')) {
                this.back();
                this.exponent();
            } else {
                this.unary();
                this.getCodeGeneratorWithTimes().onBitNot(opToken);
            }
        } else {
            this.exponent();
        }
    }

    private int getLookheadStartIndex() {
        return this.lookhead != null ? this.lexer.getCurrentIndex() - this.getLookheadLexemeLength() : -1;
    }

    private int getLookheadLexemeLength() {
        int len = this.lookhead.getLexeme().length();
        if (this.lookhead.getType() == Token.TokenType.String) {
            len += 2;
        }
        return len;
    }

    private String getParamExp(int lastTokenIndex) {
        if (lastTokenIndex >= 0 && this.getLookheadStartIndex() >= 0) {
            return this.lexer.getScanString().substring(lastTokenIndex, this.getLookheadStartIndex());
        }
        return null;
    }

    public boolean isOPVariable(Token<?> token) {
        if (token.getType() != Token.TokenType.Char) {
            return false;
        }
        CharToken charToken = (CharToken)token;
        this.move(true);
        if (this.expectChar(',') || this.expectChar(')')) {
            this.back();
            String lexeme = String.valueOf(charToken.getCh());
            if (lexeme.equals("-")) {
                lexeme = "-sub";
            }
            return this.instance.containsFunction(lexeme);
        }
        this.back();
        return false;
    }

    public void factor() {
        if (this.factor0()) {
            this.methodInvokeOrArrayAccess();
        }
    }

    private boolean factor0() {
        if (this.lookhead == null) {
            this.reportSyntaxError("illegal token");
        }
        if (this.lookhead == Variable.END) {
            return false;
        }
        if (this.expectChar('(')) {
            this.move(true);
            this.scope.enterParen();
            this.ternary();
            if (this.expectChar(')')) {
                this.move(true);
                this.scope.leaveParen();
            }
        } else if (this.lookhead.getType() == Token.TokenType.Number || this.lookhead.getType() == Token.TokenType.String || this.lookhead.getType() == Token.TokenType.Variable || this.lookhead == Variable.TRUE || this.lookhead == Variable.FALSE || this.isOPVariable(this.lookhead)) {
            if (this.lookhead.getType() == Token.TokenType.Variable) {
                this.checkVariableName(this.lookhead);
            }
            if (this.lookhead.getType() == Token.TokenType.Char) {
                CharToken charToken = (CharToken)this.lookhead;
                if (!ExpressionLexer.isBinaryOP(charToken.getCh())) {
                    this.reportSyntaxError("unexpect char '" + charToken.getCh() + "'");
                }
                this.lookhead = this.lexer.getSymbolTable().reserve(new Variable(charToken.getLexeme(), charToken.getLineNo(), charToken.getStartIndex()));
            }
            this.move(true);
            Token<?> prev = this.getPrevToken();
            if (prev.getType() == Token.TokenType.Variable && this.expectChar('(')) {
                if (prev == Variable.LAMBDA) {
                    this.lambda(false);
                } else if (prev == Variable.FN) {
                    this.lambda(true);
                } else {
                    this.method(prev);
                }
            } else if (prev.getType() == Token.TokenType.Variable) {
                if (!this.arrayAccess()) {
                    this.getCodeGeneratorWithTimes().onConstant(prev);
                }
            } else {
                this.getCodeGeneratorWithTimes().onConstant(prev);
            }
        } else if (this.expectChar('/')) {
            this.pattern();
        } else {
            if (this.expectChar('}')) {
                return false;
            }
            this.reportSyntaxError("invalid token");
        }
        return true;
    }

    private void lambda(boolean fn) {
        this.ensureFeatureEnabled(Feature.Lambda);
        this.scope.enterLambda();
        this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken());
        this.scope.enterParen();
        this.move(true);
        int paramIndex = 0;
        FunctionParam lastParam = null;
        ArrayList<FunctionParam> variadicParams = new ArrayList<FunctionParam>(2);
        if (!this.expectChar(')')) {
            if ((lastParam = this.lambdaArgument(paramIndex++)).isVariadic()) {
                variadicParams.add(lastParam);
            }
            while (this.expectChar(',')) {
                this.move(true);
                if (!(lastParam = this.lambdaArgument(paramIndex++)).isVariadic()) continue;
                variadicParams.add(lastParam);
            }
        }
        if (variadicParams.size() > 1) {
            this.reportSyntaxError("The variadic parameter must be the last parameter: `" + ((FunctionParam)variadicParams.get(0)).getName() + "`");
        }
        if (variadicParams.size() > 0 && variadicParams.get(0) != lastParam) {
            this.reportSyntaxError("The variadic parameter must be the last parameter: `" + ((FunctionParam)variadicParams.get(0)).getName() + "`");
        }
        if (this.expectChar(')')) {
            this.scope.leaveParen();
            this.move(true);
            if (fn) {
                if (!this.expectChar('{')) {
                    this.reportSyntaxError("expect '{'");
                }
            } else {
                if (!this.expectChar('-')) {
                    this.reportSyntaxError("expect '->' for lambda body");
                }
                this.move(true);
                if (!this.expectChar('>')) {
                    this.reportSyntaxError("expect '->' for lambda body");
                }
            }
            this.move(true);
            this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
            this.statements();
            if (fn) {
                if (!this.expectChar('}')) {
                    this.reportSyntaxError("missing '}' to close function body");
                }
            } else if (this.lookhead != Variable.END) {
                this.reportSyntaxError("expect lambda 'end'");
            }
            this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
            this.scope.leaveLambda();
            this.move(true);
        }
    }

    private String currentTokenLexeme() {
        return this.lookhead == null ? "END_OF_STRING" : this.lookhead.getLexeme();
    }

    private FunctionParam lambdaArgument(int index) {
        if (this.expectChar('&')) {
            this.move(true);
            if (this.lookhead.getType() != Token.TokenType.Variable) {
                this.reportSyntaxError("expect argument name, but is: " + this.currentTokenLexeme());
            }
            return this.lambdaArgument0(index, true);
        }
        if (this.lookhead.getType() == Token.TokenType.Variable) {
            return this.lambdaArgument0(index, false);
        }
        this.reportSyntaxError("expect argument name, but is: " + this.currentTokenLexeme());
        return null;
    }

    private FunctionParam lambdaArgument0(int index, boolean isVariadic) {
        if (!ExpressionParser.isJavaIdentifier(this.lookhead.getLexeme())) {
            this.reportSyntaxError("illegal argument name: " + this.currentTokenLexeme());
        }
        FunctionParam param = new FunctionParam(index, this.lookhead.getLexeme(), isVariadic);
        this.getCodeGeneratorWithTimes().onLambdaArgument(this.lookhead, param);
        this.move(true);
        return param;
    }

    private boolean arrayAccess() {
        boolean hasArray = false;
        while (this.expectChar('[')) {
            if (!hasArray) {
                this.getCodeGeneratorWithTimes().onArray(this.getPrevToken());
                this.move(true);
                hasArray = true;
            } else {
                this.move(true);
            }
            this.getCodeGeneratorWithTimes().onArrayIndexStart(this.getPrevToken());
            this.array();
        }
        return hasArray;
    }

    private void array() {
        this.scope.enterBracket();
        if (this.getPrevToken() == Variable.TRUE || this.getPrevToken() == Variable.FALSE || this.getPrevToken() == Variable.NIL) {
            this.reportSyntaxError(this.getPrevToken().getLexeme() + " could not use [] operator");
        }
        if (!this.ternary()) {
            this.reportSyntaxError("missing index for array access");
        }
        if (this.expectChar(']')) {
            this.scope.leaveBracket();
            this.move(true);
            this.getCodeGeneratorWithTimes().onArrayIndexEnd(this.lookhead);
        }
    }

    private void checkVariableName(Token<?> token) {
        if (token.getType() == Token.TokenType.Delegate) {
            return;
        }
        if (!((Variable)token).isQuote()) {
            String[] names;
            for (String name : names = token.getLexeme().split("\\.")) {
                if (ExpressionParser.isJavaIdentifier(name)) continue;
                this.reportSyntaxError("illegal identifier: " + name);
            }
        }
    }

    private void methodInvokeOrArrayAccess() {
        while ((this.expectChar('[') || this.expectChar('(')) && !ExpressionParser.isConstant(this.getPrevToken(), this.instance)) {
            if (this.expectChar('[')) {
                this.arrayAccess();
                continue;
            }
            if (!this.expectChar('(')) continue;
            this.method(this.anonymousMethodName());
        }
    }

    private void method(Token<?> methodName) {
        if (this.expectChar('(')) {
            this.scope.enterParen();
            this.checkVariableName(methodName);
            this.checkFunctionName(methodName, false);
            this.getCodeGeneratorWithTimes().onMethodName(methodName);
            this.move(true);
            int paramIndex = 0;
            ArrayList<FunctionArgument> params = null;
            boolean unpackArguments = false;
            if (this.captureFuncArgs) {
                params = new ArrayList<FunctionArgument>();
            }
            int lastTokenIndex = this.getLookheadStartIndex();
            if (!this.expectChar(')')) {
                boolean isPackArgs = false;
                if (this.expectChar('*')) {
                    this.move(true);
                    if (this.expectChar('*') || this.expectChar(',')) {
                        this.back();
                    } else {
                        unpackArguments = true;
                        this.withMetaBegin();
                        isPackArgs = true;
                    }
                }
                this.ternary();
                if (isPackArgs) {
                    this.withMetaEnd("unpackingArgs", true);
                }
                this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
                if (this.captureFuncArgs) {
                    params.add(new FunctionArgument(paramIndex++, this.getParamExp(lastTokenIndex)));
                }
                while (this.expectChar(',')) {
                    this.move(true);
                    isPackArgs = false;
                    lastTokenIndex = this.getLookheadStartIndex();
                    if (this.expectChar('*')) {
                        this.move(true);
                        if (this.expectChar('*') || this.expectChar(',')) {
                            this.back();
                        } else {
                            unpackArguments = true;
                            this.withMetaBegin();
                            isPackArgs = true;
                        }
                    }
                    if (!this.ternary()) {
                        this.reportSyntaxError("invalid argument");
                    }
                    if (isPackArgs) {
                        this.withMetaEnd("unpackingArgs", true);
                    }
                    this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
                    if (!this.captureFuncArgs) continue;
                    params.add(new FunctionArgument(paramIndex++, this.getParamExp(lastTokenIndex)));
                }
            }
            if (unpackArguments) {
                methodName.withMeta("unpackingArgs", true);
            }
            if (this.expectChar(')')) {
                this.getCodeGeneratorWithTimes().onMethodInvoke(this.currentToken().withMeta("params", params));
                this.move(true);
                this.scope.leaveParen();
            }
        }
    }

    public static final boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        if (id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return !id.equals("null");
    }

    private void pattern() {
        int startIndex = this.lookhead.getStartIndex();
        this.move(true);
        this.inPattern = true;
        StringBuilder sb = new StringBuilder();
        while (this.lookhead != null) {
            while (!this.expectChar('/') && this.lookhead != null) {
                sb.append(this.lookhead.getLexeme());
                this.move(false);
            }
            if (this.getPrevToken().getType() == Token.TokenType.Char && ((CharToken)this.getPrevToken()).getLexeme().equals("\\")) {
                sb.append("/");
                this.move(false);
                continue;
            }
            this.inPattern = false;
            break;
        }
        if (this.inPattern) {
            this.reportSyntaxError("invalid regular pattern:" + sb.toString());
        }
        this.getCodeGeneratorWithTimes().onConstant(new PatternToken(sb.toString(), this.lexer.getLineNo(), startIndex));
        this.move(true);
    }

    public void reportSyntaxError(String message) {
        int index;
        int n = index = this.isValidLookhead() ? this.lookhead.getStartIndex() : this.lexer.getCurrentIndex();
        if (this.lookhead != null) {
            this.lexer.pushback(this.lookhead);
        }
        String msg = "Syntax error: " + message + " at " + index + ", lineNumber: " + this.lexer.getLineNo() + ", token : " + this.lookhead + ",\nwhile parsing expression: `\n" + this.lexer.getScanString() + "^^^\n`";
        ExpressionSyntaxErrorException e = new ExpressionSyntaxErrorException(msg);
        StackTraceElement[] traces = e.getStackTrace();
        ArrayList<StackTraceElement> filteredTraces = new ArrayList<StackTraceElement>();
        for (StackTraceElement t : traces) {
            if (!this.instance.getOptionValue((Options)Options.TRACE_EVAL).bool && t.getClassName().equals(this.getClass().getName())) continue;
            filteredTraces.add(t);
        }
        e.setStackTrace(filteredTraces.toArray(new StackTraceElement[filteredTraces.size()]));
        throw e;
    }

    private boolean isValidLookhead() {
        return this.lookhead != null && this.lookhead.getStartIndex() > 0;
    }

    public void move(boolean analyse) {
        if (this.lookhead != null) {
            this.prevTokens.push(this.lookhead);
            this.lookhead = this.lexer.scan(analyse);
            if (this.lookhead != null) {
                ++this.parsedTokens;
            }
        } else {
            this.reportSyntaxError("illegal token");
        }
    }

    public int getParsedTokens() {
        return this.parsedTokens;
    }

    public void back() {
        if (this.lookhead != null) {
            --this.parsedTokens;
        }
        this.lexer.pushback(this.lookhead);
        this.lookhead = this.getPrevToken();
    }

    public Expression parse(boolean reportErrorIfNotEOF) {
        StatementType statementType = this.statements();
        if (this.lookhead != null && reportErrorIfNotEOF) {
            if (statementType == StatementType.Ternary) {
                this.reportSyntaxError("unexpect token '" + this.currentTokenLexeme() + "', maybe forget to insert ';' to complete last expression ");
            } else {
                this.reportSyntaxError("unexpect token '" + this.currentTokenLexeme() + "'");
            }
        }
        return this.getCodeGeneratorWithTimes().getResult(true);
    }

    public Expression parse() {
        return this.parse(true);
    }

    private void breakStatement() {
        if (!this.scope.newLexicalScope) {
            this.reportSyntaxError("break only can be used in for-loop");
        }
        this.move(true);
        this.getCodeGeneratorWithTimes().onMethodName(Constants.ReducerBreakFn);
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
        if (!this.expectChar(';')) {
            this.reportSyntaxError("missing ';' for break");
        }
        this.move(true);
    }

    private void continueStatement() {
        if (!this.scope.newLexicalScope) {
            this.reportSyntaxError("continue only can be used in for-loop");
        }
        this.move(true);
        this.getCodeGeneratorWithTimes().onMethodName(Constants.ReducerContFn);
        this.getCodeGeneratorWithTimes().onConstant(Variable.NIL);
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
        if (!this.expectChar(';')) {
            this.reportSyntaxError("missing ';' for continue");
        }
        this.move(true);
    }

    private void whileStatement() {
        this.move(true);
        this.getCodeGeneratorWithTimes().onMethodName(Constants.ReducerFn);
        this.getCodeGeneratorWithTimes().onConstant(Constants.REDUCER_LOOP);
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        boolean newLexicalScope = this.scope.newLexicalScope;
        this.scope.newLexicalScope = true;
        this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope));
        this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
        this.ifStatement(true, false);
        this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
        this.getCodeGenerator().onMethodParameter(this.lookhead);
        if (this.expectChar(';')) {
            this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
        } else {
            this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope).withMeta("inheritEnv", true));
            this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
            if (this.statements() == StatementType.Empty) {
                this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
            }
            this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
        }
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
        this.scope.newLexicalScope = newLexicalScope;
    }

    private void letStatement() {
        this.move(true);
        Token<?> var = this.lookhead;
        this.checkVariableName(var);
        this.getCodeGenerator().onConstant(var);
        this.move(true);
        if (!this.expectChar('=')) {
            this.reportSyntaxError("expect '='");
        }
        this.move(true);
        StatementType stmtType = this.statement();
        if (stmtType == StatementType.Empty) {
            this.reportSyntaxError("invalid value to define");
        }
        this.checkVarIsInit(var, stmtType);
        this.ensureFeatureEnabled(Feature.Assignment);
        this.getCodeGeneratorWithTimes().onAssignment(this.currentToken().withMeta("define", true));
        if (!this.expectChar(';')) {
            this.reportSyntaxError("missing ';' for let statement");
        }
        this.move(true);
    }

    private void fnStatement() {
        this.move(true);
        if (this.expectChar('(')) {
            this.lambda(true);
        } else {
            this.checkVariableName(this.lookhead);
            this.checkFunctionName(this.lookhead, true);
            this.getCodeGeneratorWithTimes().onConstant(this.lookhead.withMeta("isInitialized", true).withMeta("type", CompileTypes.Function));
            this.move(true);
            if (!this.expectChar('(')) {
                this.reportSyntaxError("expect '(' after function name");
            }
            this.lambda(true);
            this.ensureFeatureEnabled(Feature.Assignment);
            this.getCodeGeneratorWithTimes().onAssignment(this.currentToken().withMeta("define", true));
        }
    }

    private void checkFunctionName(Token<?> token, boolean warnOnExists) {
        String fnName = token.getLexeme();
        if (SymbolTable.isReservedKeyword(fnName)) {
            this.reportSyntaxError("The function name `" + fnName + "` is a reserved keyword");
        }
        if (warnOnExists && this.instance.getFuncMap().containsKey(fnName)) {
            System.out.println("[Aviator WARN] The function '" + fnName + "' is already exists, but is replaced with new one.");
        }
    }

    private Token<?> currentToken() {
        CharToken token = this.lookhead;
        if (token == null) {
            token = new CharToken('\uffff', this.lexer.getLineNo(), this.lexer.getCurrentIndex());
        }
        return token;
    }

    private boolean scopeStatement() {
        boolean hasReturn = false;
        boolean newLexicalScope = this.scope.newLexicalScope;
        this.scope.newLexicalScope = true;
        this.getCodeGeneratorWithTimes().onMethodName(Constants.IfReturnFn);
        this.move(true);
        this.scope.enterBrace();
        this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope));
        this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
        hasReturn = this.statements() == StatementType.Return;
        this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
        this.getCodeGeneratorWithTimes().onMethodName(this.anonymousMethodName());
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
        if (!this.expectChar('}')) {
            this.reportSyntaxError("missing '}' to close scope");
        }
        this.move(true);
        this.scope.leaveBrace();
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        if (this.expectChar(';')) {
            this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
        } else {
            this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope).withMeta("inheritEnv", true));
            this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
            if (this.statements() == StatementType.Empty) {
                this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
            }
            this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
        }
        this.getCodeGenerator().onMethodParameter(this.lookhead);
        this.getCodeGenerator().onMethodInvoke(this.lookhead);
        this.scope.newLexicalScope = newLexicalScope;
        return hasReturn;
    }

    private void tryStatement() {
        this.getCodeGeneratorWithTimes().onMethodName(Constants.TRY_VAR);
        this.move(true);
        if (!this.expectChar('{')) {
            this.reportSyntaxError("expect '{' after try");
        }
        this.move(true);
        boolean newLexicalScope = this.scope.newLexicalScope;
        this.scope.newLexicalScope = true;
        this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope));
        this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
        this.statements();
        this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        if (!this.expectChar('}')) {
            this.reportSyntaxError("missing '}' for try body");
        }
        this.move(true);
        boolean hasCatch = false;
        boolean hasFinally = false;
        while (this.lookhead == Variable.CATCH) {
            if (!hasCatch) {
                this.getCodeGeneratorWithTimes().onMethodName(Constants.SEQ_LIST_VAR);
                hasCatch = true;
            }
            this.move(true);
            if (!this.expectChar('(')) {
                this.reportSyntaxError("expect '(' after catch");
            }
            this.move(true);
            if (this.lookhead == null || this.lookhead.getType() != Token.TokenType.Variable) {
                this.reportSyntaxError("invalid exception class name");
            }
            this.checkVariableName(this.lookhead);
            ArrayList exceptionClasses = new ArrayList();
            exceptionClasses.add(this.lookhead);
            this.move(true);
            Token<?> boundVar = null;
            if (this.expectChar(')')) {
                boundVar = (Token<?>)exceptionClasses.remove(0);
                exceptionClasses.add(Constants.THROWABLE_VAR);
            } else {
                while (this.expectChar('|')) {
                    this.move(true);
                    if (this.lookhead.getType() != Token.TokenType.Variable) {
                        this.reportSyntaxError("invalid exception class to catch");
                    }
                    this.checkVariableName(this.lookhead);
                    exceptionClasses.add(this.lookhead);
                    this.move(true);
                }
                if (this.lookhead == null || this.lookhead.getType() != Token.TokenType.Variable) {
                    this.reportSyntaxError("invalid bound variable name for exception");
                }
                this.checkVariableName(this.lookhead);
                boundVar = this.lookhead;
                this.move(true);
            }
            if (!this.expectChar(')')) {
                this.reportSyntaxError("missing ')' for catch caluse");
            }
            this.move(true);
            if (!this.expectChar('{')) {
                this.reportSyntaxError("missing '{' for catch block");
            }
            this.move(true);
            this.getCodeGeneratorWithTimes().onMethodName(Constants.CATCH_HANDLER_VAR);
            this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope));
            this.getCodeGeneratorWithTimes().onLambdaArgument(boundVar, new FunctionParam(0, boundVar.getLexeme(), false));
            this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
            this.statements();
            this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
            this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
            for (Token token : exceptionClasses) {
                this.getCodeGeneratorWithTimes().onConstant(token);
                this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
            }
            this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
            this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
            if (!this.expectChar('}')) {
                this.reportSyntaxError("missing '}' for to complete catch block");
            }
            this.move(true);
        }
        if (hasCatch) {
            this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
            this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        } else {
            this.getCodeGeneratorWithTimes().onConstant(Variable.NIL);
            this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        }
        if (this.lookhead == Variable.FINALLY) {
            hasFinally = true;
            this.move(true);
            if (!this.expectChar('{')) {
                this.reportSyntaxError("missing '{' for finally block");
            }
            this.move(true);
            this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope));
            this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
            this.statements();
            this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
            if (!this.expectChar('}')) {
                this.reportSyntaxError("missing '}' for finally block");
            }
            this.move(true);
        } else {
            this.getCodeGeneratorWithTimes().onConstant(Variable.NIL);
        }
        if (!hasCatch && !hasFinally) {
            this.reportSyntaxError("missing catch or finally blocks for catch");
        }
        if (this.expectChar(';')) {
            this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
        } else {
            this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope).withMeta("inheritEnv", true));
            this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
            if (this.statements() == StatementType.Empty) {
                this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
            }
            this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
        }
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        this.scope.newLexicalScope = newLexicalScope;
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
    }

    private void throwStatement() {
        this.getCodeGeneratorWithTimes().onMethodName(Constants.THROW_VAR);
        this.move(true);
        this.statement();
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
        if (!this.expectChar(';')) {
            this.reportSyntaxError("missing ';' for throw statement");
        }
    }

    private void newStatement() {
        this.ensureFeatureEnabled(Feature.NewInstance);
        this.getCodeGeneratorWithTimes().onMethodName(Constants.NEW_VAR);
        this.move(true);
        if (this.lookhead == null || this.lookhead.getType() != Token.TokenType.Variable) {
            this.reportSyntaxError("invalid class name");
        }
        this.checkVariableName(this.lookhead);
        this.getCodeGeneratorWithTimes().onConstant(this.lookhead.withMeta("type", CompileTypes.Class));
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        this.move(true);
        if (!this.expectChar('(')) {
            this.reportSyntaxError("missing '(' after class name");
        }
        this.scope.enterParen();
        this.move(true);
        if (!this.expectChar(')')) {
            this.ternary();
            this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
            while (this.expectChar(',')) {
                this.move(true);
                if (!this.ternary()) {
                    this.reportSyntaxError("invalid argument");
                }
                this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
            }
        }
        if (!this.expectChar(')')) {
            this.reportSyntaxError("missing ')' for new statement");
        }
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
        this.move(true);
        this.scope.leaveParen();
    }

    private void className() {
        if (this.lookhead.getType() != Token.TokenType.Variable && !this.expectChar('*')) {
            this.reportSyntaxError("expect variable name or * to use");
        }
        if (this.expectChar('*')) {
            this.wildcard();
        } else {
            this.checkVariableName(this.lookhead);
            this.getCodeGenerator().onConstant(this.lookhead.withMeta("useClassOrPkg", true));
        }
        this.move(true);
    }

    private void useStatement() {
        this.getCodeGeneratorWithTimes().onMethodName(Constants.USE_VAR);
        this.move(true);
        this.className();
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        if (this.expectChar('*')) {
            this.wildcard();
            this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
            this.move(true);
        } else if (this.expectChar('{')) {
            this.scope.enterBrace();
            this.move(true);
            this.className();
            this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
            while (this.expectChar(',')) {
                this.move(true);
                this.className();
                this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
            }
            if (!this.expectChar('}')) {
                this.reportSyntaxError("expect '}' to complete use statement");
            } else {
                this.move(true);
                this.scope.leaveBrace();
            }
        }
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
        if (!this.expectChar(';')) {
            this.reportSyntaxError("missing ';' for use statement");
        }
    }

    private void wildcard() {
        this.getCodeGenerator().onConstant(new Variable("*", this.lookhead.getLineNo(), this.lookhead.getStartIndex()));
    }

    private StatementType statement() {
        if (this.lookhead == Variable.IF) {
            this.ensureFeatureEnabled(Feature.If);
            if (this.ifStatement(false, false)) {
                return StatementType.Return;
            }
            return StatementType.Other;
        }
        if (this.lookhead == Variable.FOR) {
            this.ensureFeatureEnabled(Feature.ForLoop);
            this.forStatement();
            return StatementType.Other;
        }
        if (this.lookhead == Variable.RETURN) {
            this.ensureFeatureEnabled(Feature.Return);
            this.returnStatement();
            return StatementType.Return;
        }
        if (this.lookhead == Variable.BREAK) {
            this.breakStatement();
            return StatementType.Return;
        }
        if (this.lookhead == Variable.CONTINUE) {
            this.continueStatement();
            return StatementType.Return;
        }
        if (this.lookhead == Variable.LET) {
            this.ensureFeatureEnabled(Feature.Let);
            this.letStatement();
            return StatementType.Other;
        }
        if (this.lookhead == Variable.WHILE) {
            this.ensureFeatureEnabled(Feature.WhileLoop);
            this.whileStatement();
            return StatementType.Other;
        }
        if (this.lookhead == Variable.FN) {
            this.ensureFeatureEnabled(Feature.Fn);
            this.fnStatement();
            return StatementType.Other;
        }
        if (this.lookhead == Variable.TRY) {
            this.ensureFeatureEnabled(Feature.ExceptionHandle);
            this.tryStatement();
            return StatementType.Other;
        }
        if (this.lookhead == Variable.THROW) {
            this.ensureFeatureEnabled(Feature.ExceptionHandle);
            this.throwStatement();
            return StatementType.Other;
        }
        if (this.expectChar('{')) {
            this.ensureFeatureEnabled(Feature.LexicalScope);
            if (this.scopeStatement()) {
                return StatementType.Return;
            }
            return StatementType.Other;
        }
        if (this.lookhead == Variable.USE) {
            this.ensureFeatureEnabled(Feature.Use);
            this.useStatement();
            return StatementType.Other;
        }
        if (this.ternary()) {
            return StatementType.Ternary;
        }
        return StatementType.Empty;
    }

    private void withMetaBegin() {
        this.getCodeGeneratorWithTimes().onMethodName(Constants.WithMetaFn);
    }

    private void withMetaEnd(Object key, Object val) {
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        this.getCodeGeneratorWithTimes().onConstant(this.value2token(key));
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        this.getCodeGeneratorWithTimes().onConstant(this.value2token(val));
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
    }

    private Token<?> value2token(Object val) {
        if (val instanceof Token) {
            return (Token)val;
        }
        if (val == null) {
            return Variable.NIL;
        }
        if (val instanceof String) {
            return new StringToken((String)val, this.lexer.getLineNo(), this.lookhead.getStartIndex());
        }
        if (val instanceof Number) {
            return new NumberToken((Number)val, val.toString(), this.lexer.getLineNo(), this.lookhead.getStartIndex());
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? Variable.TRUE : Variable.FALSE;
        }
        throw new ExpressionRuntimeException("Unsupported compiled-time metadata type: " + val.getClass());
    }

    private void forStatement() {
        this.move(true);
        ArrayList reducerArgs = new ArrayList(2);
        while (true) {
            if (reducerArgs.size() > 2) {
                this.reportSyntaxError("Too many variables in for statement: " + reducerArgs.size());
            }
            reducerArgs.add(this.lookhead);
            this.checkVariableName(this.lookhead);
            this.move(true);
            if (!this.expectChar(',')) break;
            this.move(true);
        }
        if (this.lookhead == Variable.IN) {
            this.move(true);
            this.getCodeGeneratorWithTimes().onMethodName(Constants.ReducerFn);
            if (!this.ternary()) {
                this.reportSyntaxError("missing collection");
            }
            this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
            if (this.expectChar('{')) {
                this.move(true);
                this.scope.enterBrace();
                boolean newLexicalScope = this.scope.newLexicalScope;
                this.scope.newLexicalScope = true;
                this.withMetaBegin();
                this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope));
                for (Token token : reducerArgs) {
                    this.getCodeGeneratorWithTimes().onLambdaArgument(token, new FunctionParam(0, token.getLexeme(), false));
                }
                this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
                this.statements();
                this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
                this.withMetaEnd("arities", reducerArgs.size());
                this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
                if (this.expectChar('}')) {
                    this.move(true);
                    this.scope.leaveBrace();
                } else {
                    this.reportSyntaxError("missing '}' in for-loop");
                }
                if (this.expectChar(';')) {
                    this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
                } else {
                    this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope).withMeta("inheritEnv", true));
                    this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
                    if (this.statements() == StatementType.Empty) {
                        this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
                    }
                    this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
                }
                this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
                this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
                this.scope.newLexicalScope = newLexicalScope;
            } else {
                this.reportSyntaxError("expect '{' in for-loop");
            }
        } else {
            this.reportSyntaxError("expect 'in' keyword while using for-loop");
        }
    }

    private StatementType statements() {
        if (this.lookhead == null) {
            return StatementType.Empty;
        }
        StatementType stmtType = this.statement();
        this.ensureDepthState();
        while (this.expectChar(';') || stmtType == StatementType.Other || stmtType == StatementType.Return) {
            StatementType nextStmtType;
            this.ensureNoStatementAfterReturn(stmtType);
            if (this.lookhead != null && this.lookhead != Variable.END && !this.expectChar('}')) {
                this.getCodeGeneratorWithTimes().onTernaryEnd(this.lookhead);
            }
            if (this.expectChar(';')) {
                this.move(true);
            }
            if (this.lookhead == null || (nextStmtType = this.statement()) == StatementType.Empty) break;
            stmtType = nextStmtType;
            this.ensureDepthState();
        }
        this.ensureNoStatementAfterReturn(stmtType);
        if (stmtType == StatementType.Ternary && this.lookhead != null && !this.expectChar(';') && !this.expectChar('}') && this.lookhead != Variable.END) {
            this.back();
            this.reportSyntaxError("unexpect token '" + this.currentTokenLexeme() + "', maybe forget to insert ';' to complete last expression ");
        }
        return stmtType;
    }

    private void ensureNoStatementAfterReturn(StatementType statementType) {
        if (statementType == StatementType.Return && this.lookhead != null && this.lookhead != Variable.END && !this.expectChar('}')) {
            this.reportSyntaxError("unreachable code");
        }
    }

    private boolean ifStatement(boolean isWhile, boolean isElsif) {
        if (!isWhile) {
            this.move(true);
        }
        boolean ifBodyHasReturn = false;
        boolean elseBodyHasReturn = false;
        boolean newLexicalScope = this.scope.newLexicalScope;
        this.scope.newLexicalScope = true;
        this.getCodeGeneratorWithTimes().onMethodName(Constants.IfReturnFn);
        if (!this.ternary()) {
            this.reportSyntaxError("missing test statement for if");
        }
        this.getCodeGeneratorWithTimes().onTernaryBoolean(this.lookhead);
        if (this.expectChar('{')) {
            this.move(true);
            this.scope.enterBrace();
            this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope));
            this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
            ifBodyHasReturn = this.statements() == StatementType.Return;
            this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
            this.getCodeGeneratorWithTimes().onMethodName(this.anonymousMethodName());
            this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
            this.getCodeGeneratorWithTimes().onTernaryLeft(this.lookhead);
        } else {
            this.reportSyntaxError("expect '{' for " + this.getLoopKeyword(isWhile) + " statement");
        }
        if (!this.expectChar('}')) {
            this.reportSyntaxError("missing '}' to close " + this.getLoopKeyword(isWhile) + " body");
        }
        this.scope.leaveBrace();
        this.move(true);
        elseBodyHasReturn = this.elseStatement(isWhile, isElsif, ifBodyHasReturn);
        this.getCodeGeneratorWithTimes().onMethodParameter(this.lookhead);
        if (isWhile || isElsif) {
            this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
        } else if (this.expectChar(';')) {
            this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
        } else {
            this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.getPrevToken().withMeta("newLexicalScope", this.scope.newLexicalScope).withMeta("inheritEnv", true));
            this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
            if (this.statements() == StatementType.Empty) {
                this.getCodeGenerator().onConstant(Constants.ReducerEmptyVal);
            } else if (ifBodyHasReturn && elseBodyHasReturn && !isElsif) {
                this.reportSyntaxError("unreachable code");
            }
            this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
        }
        this.getCodeGenerator().onMethodParameter(this.lookhead);
        this.getCodeGenerator().onMethodInvoke(this.lookhead);
        this.scope.newLexicalScope = newLexicalScope;
        return ifBodyHasReturn && elseBodyHasReturn;
    }

    private String getLoopKeyword(boolean isWhile) {
        return isWhile ? "while" : "if";
    }

    private boolean elseStatement(boolean isWhile, boolean isElsif, boolean ifBodyHasReturn) {
        boolean hasElse;
        if (isWhile) {
            CodeGenerator cg = this.getCodeGeneratorWithTimes();
            cg.onMethodName(Constants.ReducerBreakFn);
            cg.onConstant(Variable.NIL);
            cg.onMethodParameter(this.lookhead);
            cg.onMethodInvoke(this.lookhead);
            cg.onTernaryRight(this.lookhead);
            return false;
        }
        if (this.expectChar(';')) {
            return this.withoutElse();
        }
        boolean hasReturn = false;
        boolean hasElsif = this.lookhead == Variable.ELSIF;
        boolean bl = hasElse = this.lookhead == Variable.ELSE;
        if (this.lookhead != null && (hasElse || hasElsif || ifBodyHasReturn)) {
            if (hasElse) {
                this.move(true);
                if (this.expectChar('{')) {
                    this.scope.enterBrace();
                    this.move(true);
                    hasReturn = this.elseBody(false);
                    if (this.expectChar('}')) {
                        this.scope.leaveBrace();
                        this.move(true);
                    } else {
                        this.reportSyntaxError("missing '}' to close 'else' body");
                    }
                } else {
                    this.reportSyntaxError("expect '{' for else statement");
                }
            } else if (hasElsif) {
                hasReturn = this.ifStatement(false, true);
                this.getCodeGenerator().onTernaryRight(this.lookhead);
            } else if (ifBodyHasReturn && !isElsif) {
                hasReturn = this.elseBody(true);
            } else {
                return this.withoutElse();
            }
            return hasReturn;
        }
        return this.withoutElse();
    }

    private boolean withoutElse() {
        CodeGenerator cg = this.getCodeGeneratorWithTimes();
        cg.onConstant(Variable.NIL);
        cg.onTernaryRight(this.lookhead);
        return false;
    }

    private boolean elseBody(boolean inheritEnv) {
        this.getCodeGeneratorWithTimes().onLambdaDefineStart(this.lookhead.withMeta("newLexicalScope", this.scope.newLexicalScope).withMeta("inheritEnv", inheritEnv));
        this.getCodeGeneratorWithTimes().onLambdaBodyStart(this.lookhead);
        boolean hasReturn = this.statements() == StatementType.Return;
        this.getCodeGeneratorWithTimes().onLambdaBodyEnd(this.lookhead);
        this.getCodeGeneratorWithTimes().onMethodName(this.anonymousMethodName());
        this.getCodeGeneratorWithTimes().onMethodInvoke(this.lookhead);
        this.getCodeGeneratorWithTimes().onTernaryRight(this.lookhead);
        return hasReturn;
    }

    private DelegateToken anonymousMethodName() {
        return new DelegateToken(this.lookhead, DelegateToken.DelegateTokenType.Method_Name);
    }

    private void ensureDepthState() {
        DepthState state = this.scope.depthState.peekLast();
        if (state != null) {
            this.back();
            switch (state) {
                case Parent: {
                    if (this.scope.parenDepth <= 0) break;
                    this.reportSyntaxError("insert ')' to complete statement");
                    break;
                }
                case Bracket: {
                    if (this.scope.bracketDepth <= 0) break;
                    this.reportSyntaxError("insert ']' to complete statement");
                    break;
                }
                case Lambda: {
                    if (this.scope.lambdaDepth <= 0) break;
                    this.reportSyntaxError("insert 'end' to complete lambda statement");
                    break;
                }
                case Brace: {
                    if (this.scope.braceDepth <= 0) break;
                    this.reportSyntaxError("insert '}' to complete statement");
                }
            }
        }
    }

    public static boolean isConstant(Token<?> token, AviatorEvaluatorInstance instance) {
        switch (token.getType()) {
            case Number: 
            case Pattern: {
                return true;
            }
            case String: {
                return !instance.isFeatureEnabled(Feature.StringInterpolation);
            }
        }
        return false;
    }

    public static boolean isLiteralToken(Token<?> token, AviatorEvaluatorInstance instance) {
        switch (token.getType()) {
            case Variable: {
                return token == Variable.TRUE || token == Variable.FALSE || token == Variable.NIL;
            }
            case Number: 
            case Pattern: 
            case Char: {
                return true;
            }
            case String: {
                return !instance.isFeatureEnabled(Feature.StringInterpolation);
            }
        }
        return false;
    }

    private final CodeGenerator getCodeGeneratorWithTimes() {
        ++this.getCGTimes;
        return this.codeGenerator;
    }

    static enum StatementType {
        Ternary,
        Return,
        Empty,
        Other;

    }
}

