/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Audit;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.model.ModelVersion;

@DeveloperApi
public class ModelVersionInfo {
    private final Map<String, String> uris;
    private final Map<String, String> properties;
    private final Optional<String[]> aliases;
    private final Optional<String> comment;
    private final Optional<Audit> audit;

    public ModelVersionInfo(ModelVersion modelVersion) {
        this(modelVersion.uris(), modelVersion.comment(), (Map<String, String>)modelVersion.properties(), modelVersion.aliases(), modelVersion.auditInfo());
    }

    public ModelVersionInfo(String uri, String comment, Map<String, String> properties, String[] aliases) {
        this(uri, comment, properties, aliases, null);
    }

    public ModelVersionInfo(String uri, String comment, Map<String, String> properties, String[] aliases, Audit auditInfo) {
        this.uris = uri == null ? Collections.emptyMap() : ImmutableMap.of((Object)"unknown", (Object)uri);
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.comment = Optional.ofNullable(comment);
        this.audit = Optional.ofNullable(auditInfo);
        this.aliases = Optional.ofNullable(aliases);
    }

    public ModelVersionInfo(Map<String, String> uris, String comment, Map<String, String> properties, String[] aliases, Audit auditInfo) {
        this.uris = uris;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.comment = Optional.ofNullable(comment);
        this.audit = Optional.ofNullable(auditInfo);
        this.aliases = Optional.ofNullable(aliases);
    }

    public String uri() {
        return this.uris.get("unknown");
    }

    public Map<String, String> uris() {
        return this.uris;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Optional<String[]> aliases() {
        return this.aliases;
    }

    public Optional<String> comment() {
        return this.comment;
    }

    public Optional<Audit> audit() {
        return this.audit;
    }
}

