/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RestClient.class);
    private static final int DEFAULT_MAX_CONNECTIONS = 20;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 10;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final Map<String, String> defaultHeaders;
    private final int maxRetries;
    private final long retryDelayMs;

    private RestClient(CloseableHttpClient httpClient, ObjectMapper objectMapper, String baseUrl, Map<String, String> defaultHeaders, int maxRetries, long retryDelayMs) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.defaultHeaders = defaultHeaders;
        this.maxRetries = maxRetries;
        this.retryDelayMs = retryDelayMs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T get(String path, Class<T> responseType) throws IOException {
        return this.get(path, Collections.emptyMap(), responseType);
    }

    public <T> T get(String path, Map<String, String> queryParams, Class<T> responseType) throws IOException {
        String url = this.buildUrl(path, queryParams);
        HttpGet request = new HttpGet(url);
        return this.executeRequest((HttpUriRequestBase)request, responseType);
    }

    public <T> T post(String path, Object body, Class<T> responseType) throws IOException {
        return this.post(path, body, Collections.emptyMap(), responseType);
    }

    public <T> T post(String path, Object body, Map<String, String> queryParams, Class<T> responseType) throws IOException {
        String url = this.buildUrl(path, queryParams);
        HttpPost request = new HttpPost(url);
        if (body != null) {
            String jsonBody = this.objectMapper.writeValueAsString(body);
            request.setEntity((HttpEntity)new StringEntity(jsonBody, ContentType.APPLICATION_JSON));
        }
        return this.executeRequest((HttpUriRequestBase)request, responseType);
    }

    public <T> T put(String path, Object body, Class<T> responseType) throws IOException {
        return this.put(path, body, Collections.emptyMap(), responseType);
    }

    public <T> T put(String path, Object body, Map<String, String> queryParams, Class<T> responseType) throws IOException {
        String url = this.buildUrl(path, queryParams);
        HttpPut request = new HttpPut(url);
        if (body != null) {
            String jsonBody = this.objectMapper.writeValueAsString(body);
            request.setEntity((HttpEntity)new StringEntity(jsonBody, ContentType.APPLICATION_JSON));
        }
        return this.executeRequest((HttpUriRequestBase)request, responseType);
    }

    public <T> T patch(String path, Object body, Class<T> responseType) throws IOException {
        return this.patch(path, body, Collections.emptyMap(), responseType);
    }

    public <T> T patch(String path, Object body, Map<String, String> queryParams, Class<T> responseType) throws IOException {
        String url = this.buildUrl(path, queryParams);
        HttpPatch request = new HttpPatch(url);
        if (body != null) {
            String jsonBody = this.objectMapper.writeValueAsString(body);
            request.setEntity((HttpEntity)new StringEntity(jsonBody, ContentType.APPLICATION_JSON));
        }
        return this.executeRequest((HttpUriRequestBase)request, responseType);
    }

    public <T> T delete(String path, Class<T> responseType) throws IOException {
        return this.delete(path, Collections.emptyMap(), responseType);
    }

    public <T> T delete(String path, Map<String, String> queryParams, Class<T> responseType) throws IOException {
        String url = this.buildUrl(path, queryParams);
        HttpDelete request = new HttpDelete(url);
        return this.executeRequest((HttpUriRequestBase)request, responseType);
    }

    public void delete(String path) throws IOException {
        this.delete(path, Collections.emptyMap());
    }

    public void delete(String path, Map<String, String> queryParams) throws IOException {
        String url = this.buildUrl(path, queryParams);
        HttpDelete request = new HttpDelete(url);
        this.executeRequest((HttpUriRequestBase)request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeRequest(HttpUriRequestBase request, Class<T> responseType) throws IOException {
        this.defaultHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequestBase)request).addHeader(arg_0, arg_1));
        IOException lastException = null;
        int attempt = 0;
        while (attempt <= this.maxRetries) {
            if (attempt > 0) {
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryDelayMs * (long)attempt);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted during retry delay", e);
                }
            }
            try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);){
                int statusCode = response.getCode();
                HttpEntity entity = response.getEntity();
                String responseBody = null;
                if (entity != null) {
                    try {
                        responseBody = EntityUtils.toString((HttpEntity)entity);
                    }
                    catch (ParseException e) {
                        throw new IOException("Failed to parse response body", e);
                    }
                }
                if (statusCode >= 200 && statusCode < 300) {
                    if (responseType == null || responseType == Void.class) {
                        T t = null;
                        return t;
                    }
                    if (responseBody != null && !responseBody.isEmpty()) {
                        Object object = this.objectMapper.readValue(responseBody, responseType);
                        return (T)object;
                    }
                    T t = null;
                    return t;
                }
                if (statusCode >= 400 && statusCode < 500) {
                    throw new RestClientException(statusCode, responseBody, String.format("Request failed with status %d: %s", statusCode, responseBody));
                }
                LOG.warn("HTTP request failed with status {}: {}", (Object)statusCode, (Object)responseBody);
                lastException = new IOException(String.format("Request failed with status %d: %s", statusCode, responseBody));
            }
            catch (RestClientException e) {
                throw e;
            }
            catch (IOException e) {
                lastException = e;
                LOG.warn("Request attempt {} failed: {}", (Object)(attempt + 1), (Object)e.getMessage());
            }
            ++attempt;
        }
        throw new IOException("Request failed after " + (this.maxRetries + 1) + " attempts", lastException);
    }

    private String buildUrl(String path, Map<String, String> queryParams) {
        StringBuilder url = new StringBuilder(this.baseUrl);
        if (!path.startsWith("/")) {
            url.append("/");
        }
        url.append(path);
        if (!queryParams.isEmpty()) {
            url.append("?");
            queryParams.forEach((key, value) -> {
                try {
                    url.append((String)key).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to encode query parameter: " + key, e);
                }
            });
            url.setLength(url.length() - 1);
        }
        return url.toString();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public static class Builder {
        private String baseUrl;
        private Map<String, String> defaultHeaders = new HashMap<String, String>();
        private int connectTimeoutSeconds = 10;
        private int readTimeoutSeconds = 60;
        private int maxRetries = 3;
        private long retryDelayMs = 1000L;
        private int maxConnections = 20;
        private int maxConnectionsPerRoute = 10;
        private ObjectMapper objectMapper = new ObjectMapper();

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder defaultHeaders(Map<String, String> headers) {
            this.defaultHeaders = headers;
            return this;
        }

        public Builder connectTimeout(int seconds) {
            this.connectTimeoutSeconds = seconds;
            return this;
        }

        public Builder readTimeout(int seconds) {
            this.readTimeoutSeconds = seconds;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder retryDelayMs(long retryDelayMs) {
            this.retryDelayMs = retryDelayMs;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder maxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public RestClient build() {
            if (this.baseUrl == null) {
                throw new IllegalArgumentException("Base URL is required");
            }
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(this.maxConnections);
            connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)this.connectTimeoutSeconds)).setResponseTimeout(Timeout.ofSeconds((long)this.readTimeoutSeconds)).build();
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
            return new RestClient(httpClient, this.objectMapper, this.baseUrl, this.defaultHeaders, this.maxRetries, this.retryDelayMs);
        }
    }

    public static class RestClientException
    extends IOException {
        private final int statusCode;
        private final String responseBody;

        public RestClientException(int statusCode, String responseBody, String message) {
            super(message);
            this.statusCode = statusCode;
            this.responseBody = responseBody;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResponseBody() {
            return this.responseBody;
        }
    }
}

