/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iceberg.encryption.EncryptedKey;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class BaseEncryptedKey
implements EncryptedKey {
    private final String keyId;
    private final ByteBuffer keyMetadata;
    private final String encryptedById;
    private final Map<String, String> properties;

    public BaseEncryptedKey(String keyId, ByteBuffer keyMetadata, String encryptedById, Map<String, String> properties) {
        Preconditions.checkArgument((keyId != null ? 1 : 0) != 0, (Object)"Key id cannot be null");
        Preconditions.checkArgument((keyMetadata != null ? 1 : 0) != 0, (Object)"Encrypted key metadata cannot be null");
        this.keyId = keyId;
        this.keyMetadata = keyMetadata;
        this.encryptedById = encryptedById;
        this.properties = properties;
    }

    public String keyId() {
        return this.keyId;
    }

    public ByteBuffer encryptedKeyMetadata() {
        return this.keyMetadata;
    }

    public String encryptedById() {
        return this.encryptedById;
    }

    public Map<String, String> properties() {
        return this.properties;
    }
}

