/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import java.util.Arrays;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.heap.AbstractHeapVector;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;

public class HeapBytesVector
extends AbstractHeapVector
implements WritableBytesVector {
    private static final long serialVersionUID = -8529155738773478597L;
    public int[] start;
    public int[] length;
    public byte[] buffer;
    private int bytesAppended;

    public HeapBytesVector(int capacity) {
        super(capacity);
        this.buffer = new byte[capacity * 16];
        this.start = new int[capacity];
        this.length = new int[capacity];
    }

    @Override
    public void reset() {
        super.reset();
        if (this.start.length != this.capacity) {
            this.start = new int[this.capacity];
        } else {
            Arrays.fill(this.start, 0);
        }
        if (this.length.length != this.capacity) {
            this.length = new int[this.capacity];
        } else {
            Arrays.fill(this.length, 0);
        }
        Arrays.fill(this.buffer, (byte)0);
        this.bytesAppended = 0;
    }

    @Override
    public void putByteArray(int elementNum, byte[] sourceBuf, int start, int length) {
        this.reserveBytes(this.bytesAppended + length);
        System.arraycopy(sourceBuf, start, this.buffer, this.bytesAppended, length);
        this.start[elementNum] = this.bytesAppended;
        this.length[elementNum] = length;
        this.bytesAppended += length;
    }

    @Override
    public void fill(byte[] value) {
        int i;
        this.reserveBytes(this.start.length * value.length);
        for (i = 0; i < this.start.length; ++i) {
            System.arraycopy(value, 0, this.buffer, i * value.length, value.length);
        }
        for (i = 0; i < this.start.length; ++i) {
            this.start[i] = i * value.length;
        }
        Arrays.fill(this.length, value.length);
    }

    private void reserveBytes(int newCapacity) {
        if (newCapacity > this.buffer.length) {
            int newBytesCapacity = newCapacity * 2;
            try {
                this.buffer = Arrays.copyOf(this.buffer, newBytesCapacity);
            }
            catch (NegativeArraySizeException e) {
                throw new RuntimeException(String.format("The new claimed capacity %s is too large, will overflow the INTEGER.MAX after multiply by 2. Try reduce `read.batch-size` to avoid this exception.", newCapacity), e);
            }
        }
    }

    @Override
    void reserveForHeapVector(int newCapacity) {
        if (newCapacity > this.capacity) {
            this.capacity = newCapacity;
            this.start = Arrays.copyOf(this.start, newCapacity);
            this.length = Arrays.copyOf(this.length, newCapacity);
        }
    }

    @Override
    public BytesColumnVector.Bytes getBytes(int i) {
        if (this.dictionary == null) {
            return new BytesColumnVector.Bytes(this.buffer, this.start[i], this.length[i]);
        }
        byte[] bytes = this.dictionary.decodeToBinary(this.dictionaryIds.vector[i]);
        return new BytesColumnVector.Bytes(bytes, 0, bytes.length);
    }
}

