/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format;

import java.util.Arrays;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.statistics.NoneSimpleColStatsCollector;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public class SimpleStatsCollector {
    private final RowDataToObjectArrayConverter converter;
    private final SimpleColStatsCollector[] statsCollectors;
    private final Serializer<Object>[] fieldSerializers;
    private final boolean isDisabled;

    public SimpleStatsCollector(RowType rowType) {
        this(rowType, SimpleColStatsCollector.createFullStatsFactories(rowType.getFieldCount()));
    }

    public SimpleStatsCollector(RowType rowType, SimpleColStatsCollector.Factory[] collectorFactory) {
        int numFields = rowType.getFieldCount();
        Preconditions.checkArgument((numFields == collectorFactory.length ? 1 : 0) != 0, (String)"numFields %s should equal to stats length %s.", (Object[])new Object[]{numFields, collectorFactory.length});
        this.statsCollectors = SimpleColStatsCollector.create(collectorFactory);
        this.converter = new RowDataToObjectArrayConverter(rowType);
        this.fieldSerializers = new Serializer[numFields];
        for (int i = 0; i < numFields; ++i) {
            this.fieldSerializers[i] = InternalSerializers.create(rowType.getTypeAt(i));
        }
        this.isDisabled = Arrays.stream(this.statsCollectors).allMatch(p -> p instanceof NoneSimpleColStatsCollector);
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void collect(InternalRow row) {
        Object[] objects = this.converter.convert(row);
        for (int i = 0; i < row.getFieldCount(); ++i) {
            SimpleColStatsCollector collector = this.statsCollectors[i];
            Object obj = objects[i];
            collector.collect(obj, this.fieldSerializers[i]);
        }
    }

    public SimpleColStats[] extract() {
        SimpleColStats[] stats = new SimpleColStats[this.statsCollectors.length];
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = this.statsCollectors[i].result();
        }
        return stats;
    }
}

