/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import org.apache.paimon.memory.MemorySlice;

public class MemorySliceInput {
    private final MemorySlice slice;
    private int position;

    public MemorySliceInput(MemorySlice slice) {
        this.slice = slice;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position) {
        if (position < 0 || position > this.slice.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.position = position;
    }

    public boolean isReadable() {
        return this.available() > 0;
    }

    public int available() {
        return this.slice.length() - this.position;
    }

    public byte readByte() {
        if (this.position == this.slice.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.slice.readByte(this.position++);
    }

    public int readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    public int readInt() {
        int v = this.slice.readInt(this.position);
        this.position += 4;
        return v;
    }

    public int readVarLenInt() {
        int result = 0;
        for (int offset = 0; offset < 32; offset += 7) {
            int b = this.readUnsignedByte();
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new Error("Malformed integer.");
    }

    public long readLong() {
        long v = this.slice.readLong(this.position);
        this.position += 8;
        return v;
    }

    public long readVarLenLong() {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            long b = this.readUnsignedByte();
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new Error("Malformed long.");
    }

    public MemorySlice readSlice(int length) {
        MemorySlice newSlice = this.slice.slice(this.position, length);
        this.position += length;
        return newSlice;
    }
}

