/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.meta.NamespacedEntityId;
import org.apache.gravitino.meta.StatisticEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.StatisticMetaMapper;
import org.apache.gravitino.storage.relational.po.StatisticPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class StatisticMetaService {
    private static final StatisticMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;

    public static StatisticMetaService getInstance() {
        return INSTANCE;
    }

    private StatisticMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listStatisticsByEntity")
    public List<StatisticEntity> listStatisticsByEntity(NameIdentifier identifier, Entity.EntityType type) {
        NameIdentifier nameIdentifier = identifier;
        Entity.EntityType entityType = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)nameIdentifier, (Object)((Object)entityType));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = StatisticMetaService.class.getDeclaredMethod("listStatisticsByEntity", NameIdentifier.class, Entity.EntityType.class).getAnnotation(Monitored.class);
        }
        return (List)StatisticMetaService.listStatisticsByEntity_aroundBody1$advice(this, nameIdentifier, entityType, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="batchInsertStatisticPOsOnDuplicateKeyUpdate")
    public void batchInsertStatisticPOsOnDuplicateKeyUpdate(List<StatisticEntity> statisticEntities, NameIdentifier entity, Entity.EntityType type) {
        List<StatisticEntity> list = statisticEntities;
        NameIdentifier nameIdentifier = entity;
        Entity.EntityType entityType = type;
        Object[] objectArray = new Object[]{list, nameIdentifier, entityType};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = StatisticMetaService.class.getDeclaredMethod("batchInsertStatisticPOsOnDuplicateKeyUpdate", List.class, NameIdentifier.class, Entity.EntityType.class).getAnnotation(Monitored.class);
        }
        StatisticMetaService.batchInsertStatisticPOsOnDuplicateKeyUpdate_aroundBody3$advice(this, list, nameIdentifier, entityType, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="batchDeleteStatisticPOs")
    public int batchDeleteStatisticPOs(NameIdentifier identifier, Entity.EntityType type, List<String> statisticNames) {
        NameIdentifier nameIdentifier = identifier;
        Entity.EntityType entityType = type;
        List<String> list = statisticNames;
        Object[] objectArray = new Object[]{nameIdentifier, entityType, list};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = StatisticMetaService.class.getDeclaredMethod("batchDeleteStatisticPOs", NameIdentifier.class, Entity.EntityType.class, List.class).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)StatisticMetaService.batchDeleteStatisticPOs_aroundBody5$advice(this, nameIdentifier, entityType, list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteStatisticsByLegacyTimeline")
    public int deleteStatisticsByLegacyTimeline(long legacyTimeline, int limit) {
        long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = StatisticMetaService.class.getDeclaredMethod("deleteStatisticsByLegacyTimeline", Long.TYPE, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)StatisticMetaService.deleteStatisticsByLegacyTimeline_aroundBody7$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    static {
        StatisticMetaService.ajc$preClinit();
        INSTANCE = new StatisticMetaService();
    }

    private static final /* synthetic */ List listStatisticsByEntity_aroundBody0(StatisticMetaService ajc$this, NameIdentifier identifier, Entity.EntityType type, JoinPoint joinPoint) {
        NamespacedEntityId namespacedEntityId = EntityIdService.getEntityIds(identifier, type);
        List statisticPOs = SessionUtils.getWithoutCommit(StatisticMetaMapper.class, mapper -> mapper.listStatisticPOsByEntityId(namespacedEntityId.namespaceIds()[0], namespacedEntityId.entityId()));
        return statisticPOs.stream().map(StatisticPO::fromStatisticPO).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listStatisticsByEntity_aroundBody1$advice(StatisticMetaService ajc$this, NameIdentifier identifier, Entity.EntityType type, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return StatisticMetaService.listStatisticsByEntity_aroundBody0(ajc$this, identifier, type, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return StatisticMetaService.listStatisticsByEntity_aroundBody0(ajc$this, identifier, type, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = StatisticMetaService.listStatisticsByEntity_aroundBody0(ajc$this, identifier, type, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ void batchInsertStatisticPOsOnDuplicateKeyUpdate_aroundBody2(StatisticMetaService ajc$this, List statisticEntities, NameIdentifier entity, Entity.EntityType type, JoinPoint joinPoint) {
        if (statisticEntities == null || statisticEntities.isEmpty()) {
            return;
        }
        NamespacedEntityId namespacedEntityId = EntityIdService.getEntityIds(entity, type);
        List<StatisticPO> pos = StatisticPO.initializeStatisticPOs(statisticEntities, namespacedEntityId.namespaceIds()[0], namespacedEntityId.entityId(), NameIdentifierUtil.toMetadataObject(entity, type).type());
        SessionUtils.doWithCommit(StatisticMetaMapper.class, mapper -> mapper.batchInsertStatisticPOsOnDuplicateKeyUpdate(pos));
    }

    private static final /* synthetic */ Object batchInsertStatisticPOsOnDuplicateKeyUpdate_aroundBody3$advice(StatisticMetaService ajc$this, List statisticEntities, NameIdentifier entity, Entity.EntityType type, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var15_20;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                StatisticMetaService.batchInsertStatisticPOsOnDuplicateKeyUpdate_aroundBody2(ajc$this, statisticEntities, entity, type, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                StatisticMetaService.batchInsertStatisticPOsOnDuplicateKeyUpdate_aroundBody2(ajc$this, statisticEntities, entity, type, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                StatisticMetaService.batchInsertStatisticPOsOnDuplicateKeyUpdate_aroundBody2(ajc$this, statisticEntities, entity, type, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var15_20 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var15_20;
    }

    private static final /* synthetic */ int batchDeleteStatisticPOs_aroundBody4(StatisticMetaService ajc$this, NameIdentifier identifier, Entity.EntityType type, List statisticNames, JoinPoint joinPoint) {
        if (statisticNames == null || statisticNames.isEmpty()) {
            return 0;
        }
        Long entityId = EntityIdService.getEntityId(identifier, type);
        return SessionUtils.doWithCommitAndFetchResult(StatisticMetaMapper.class, mapper -> mapper.batchDeleteStatisticPOs(entityId, statisticNames));
    }

    private static final /* synthetic */ Object batchDeleteStatisticPOs_aroundBody5$advice(StatisticMetaService ajc$this, NameIdentifier identifier, Entity.EntityType type, List statisticNames, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)StatisticMetaService.batchDeleteStatisticPOs_aroundBody4(ajc$this, identifier, type, statisticNames, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)StatisticMetaService.batchDeleteStatisticPOs_aroundBody4(ajc$this, identifier, type, statisticNames, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)StatisticMetaService.batchDeleteStatisticPOs_aroundBody4(ajc$this, identifier, type, statisticNames, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteStatisticsByLegacyTimeline_aroundBody6(StatisticMetaService ajc$this, long legacyTimeline, int limit, JoinPoint joinPoint) {
        return SessionUtils.doWithCommitAndFetchResult(StatisticMetaMapper.class, mapper -> mapper.deleteStatisticsByLegacyTimeline(legacyTimeline, limit));
    }

    private static final /* synthetic */ Object deleteStatisticsByLegacyTimeline_aroundBody7$advice(StatisticMetaService ajc$this, long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)StatisticMetaService.deleteStatisticsByLegacyTimeline_aroundBody6(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)StatisticMetaService.deleteStatisticsByLegacyTimeline_aroundBody6(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)StatisticMetaService.deleteStatisticsByLegacyTimeline_aroundBody6(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StatisticMetaService.java", StatisticMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listStatisticsByEntity", "org.apache.gravitino.storage.relational.service.StatisticMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType", "identifier:type", "", "java.util.List"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "batchInsertStatisticPOsOnDuplicateKeyUpdate", "org.apache.gravitino.storage.relational.service.StatisticMetaService", "java.util.List:org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType", "statisticEntities:entity:type", "", "void"), 69);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "batchDeleteStatisticPOs", "org.apache.gravitino.storage.relational.service.StatisticMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType:java.util.List", "identifier:type:statisticNames", "", "int"), 90);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteStatisticsByLegacyTimeline", "org.apache.gravitino.storage.relational.service.StatisticMetaService", "long:int", "legacyTimeline:limit", "", "int"), 104);
    }
}

