/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.authorization.SecurableObject;

@Evolving
public interface RoleChange {
    public static RoleChange addSecurableObject(String roleName, SecurableObject securableObject) {
        return new AddSecurableObject(roleName, securableObject);
    }

    public static RoleChange removeSecurableObject(String roleName, SecurableObject securableObject) {
        return new RemoveSecurableObject(roleName, securableObject);
    }

    public static RoleChange updateSecurableObject(String roleName, SecurableObject securableObject, SecurableObject newSecurableObject) {
        return new UpdateSecurableObject(roleName, securableObject, newSecurableObject);
    }

    public static final class AddSecurableObject
    implements RoleChange {
        private final String roleName;
        private final SecurableObject securableObject;

        private AddSecurableObject(String roleName, SecurableObject securableObject) {
            this.roleName = roleName;
            this.securableObject = securableObject;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public SecurableObject getSecurableObject() {
            return this.securableObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddSecurableObject that = (AddSecurableObject)o;
            return this.roleName.equals(that.roleName) && this.securableObject.equals(that.securableObject);
        }

        public int hashCode() {
            return Objects.hash(this.roleName, this.securableObject);
        }

        public String toString() {
            return "ADDSECURABLEOBJECT " + this.roleName + " " + String.valueOf(this.securableObject);
        }
    }

    public static final class RemoveSecurableObject
    implements RoleChange {
        private final String roleName;
        private final SecurableObject securableObject;

        private RemoveSecurableObject(String roleName, SecurableObject securableObject) {
            this.roleName = roleName;
            this.securableObject = securableObject;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public SecurableObject getSecurableObject() {
            return this.securableObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveSecurableObject that = (RemoveSecurableObject)o;
            return this.roleName.equals(that.roleName) && this.securableObject.equals(that.securableObject);
        }

        public int hashCode() {
            return Objects.hash(this.roleName, this.securableObject);
        }

        public String toString() {
            return "REMOVESECURABLEOBJECT " + this.roleName + " " + String.valueOf(this.securableObject);
        }
    }

    public static final class UpdateSecurableObject
    implements RoleChange {
        private final String roleName;
        private final SecurableObject securableObject;
        private final SecurableObject newSecurableObject;

        private UpdateSecurableObject(String roleName, SecurableObject securableObject, SecurableObject newSecurableObject) {
            if (!securableObject.fullName().equals(newSecurableObject.fullName())) {
                throw new IllegalArgumentException("The securable object's metadata entity must be same as new securable object's metadata entity.");
            }
            if (securableObject.privileges().equals(newSecurableObject.privileges())) {
                throw new IllegalArgumentException("The securable object's privilege must be different as new securable object's privilege.");
            }
            this.roleName = roleName;
            this.securableObject = securableObject;
            this.newSecurableObject = newSecurableObject;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public SecurableObject getSecurableObject() {
            return this.securableObject;
        }

        public SecurableObject getNewSecurableObject() {
            return this.newSecurableObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateSecurableObject that = (UpdateSecurableObject)o;
            return this.roleName.equals(that.roleName) && this.securableObject.equals(that.securableObject) && this.newSecurableObject.equals(that.newSecurableObject);
        }

        public int hashCode() {
            return Objects.hash(this.roleName, this.securableObject, this.newSecurableObject);
        }

        public String toString() {
            return "UPDATESECURABLEOBJECT " + this.roleName + " " + String.valueOf(this.securableObject) + " " + String.valueOf(this.newSecurableObject);
        }
    }
}

