/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.twill.internal.Arguments;

public final class ArgumentsCodec
implements JsonSerializer<Arguments>,
JsonDeserializer<Arguments> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Arguments.class, (Object)new ArgumentsCodec()).create();

    public static void encode(Arguments arguments, OutputSupplier<? extends Writer> writerSupplier) throws IOException {
        try (Writer writer = (Writer)writerSupplier.getOutput();){
            GSON.toJson((Object)arguments, (Appendable)writer);
        }
    }

    public static Arguments decode(InputSupplier<? extends Reader> readerSupplier) throws IOException {
        try (Reader reader = (Reader)readerSupplier.getInput();){
            Arguments arguments = (Arguments)GSON.fromJson(reader, Arguments.class);
            return arguments;
        }
    }

    public JsonElement serialize(Arguments src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.add("arguments", context.serialize(src.getArguments()));
        json.add("runnableArguments", context.serialize((Object)src.getRunnableArguments().asMap()));
        return json;
    }

    public Arguments deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        List arguments = (List)context.deserialize(jsonObj.get("arguments"), new TypeToken<List<String>>(){}.getType());
        Map args = (Map)context.deserialize(jsonObj.get("runnableArguments"), new TypeToken<Map<String, Collection<String>>>(){}.getType());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry entry : args.entrySet()) {
            builder.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        return new Arguments(arguments, (Multimap<String, String>)builder.build());
    }
}

