/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.twill.internal.json.JsonUtils;

public final class StackTraceElementCodec
implements JsonSerializer<StackTraceElement>,
JsonDeserializer<StackTraceElement> {
    public StackTraceElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        return new StackTraceElement(JsonUtils.getAsString(jsonObj, "className"), JsonUtils.getAsString(jsonObj, "method"), JsonUtils.getAsString(jsonObj, "file"), JsonUtils.getAsInt(jsonObj, "line", -1));
    }

    public JsonElement serialize(StackTraceElement src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("className", src.getClassName());
        jsonObj.addProperty("method", src.getMethodName());
        jsonObj.addProperty("file", src.getFileName());
        jsonObj.addProperty("line", (Number)src.getLineNumber());
        return jsonObj;
    }
}

