/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.async.DaemonThreadFactory;
import org.apache.logging.log4j.core.config.CronScheduledFuture;
import org.apache.logging.log4j.core.util.CronExpression;
import org.apache.logging.log4j.status.StatusLogger;

public class ConfigurationScheduler
extends AbstractLifeCycle {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ScheduledExecutorService executorService;
    private int scheduledItems = 0;

    @Override
    public void start() {
        super.start();
        if (this.scheduledItems > 0) {
            LOGGER.debug("Starting {} Log4j2Scheduled threads", (Object)this.scheduledItems);
            if (this.scheduledItems > 5) {
                this.scheduledItems = 5;
            }
            this.executorService = new ScheduledThreadPoolExecutor(this.scheduledItems, new DaemonThreadFactory("Log4j2Scheduled-"));
        } else {
            LOGGER.debug("No scheduled items");
        }
    }

    @Override
    public void stop() {
        if (this.executorService != null) {
            LOGGER.debug("Stopping Log4j2Scheduled threads.");
            this.executorService.shutdown();
        }
        super.stop();
    }

    public void incrementScheduledItems() {
        if (!this.isStarted()) {
            ++this.scheduledItems;
        } else {
            LOGGER.error("Attempted to increment scheduled items after start");
        }
    }

    public void decrementScheduledItems() {
        if (!this.isStarted() && this.scheduledItems > 0) {
            --this.scheduledItems;
        }
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executorService.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executorService.schedule(command, delay, unit);
    }

    public CronScheduledFuture<?> scheduleWithCron(CronExpression cronExpression, Runnable command) {
        Date fireDate = cronExpression.getNextValidTimeAfter(new Date());
        CronRunnable runnable = new CronRunnable(command, cronExpression);
        ScheduledFuture<?> future = this.schedule(runnable, this.nextFireInterval(fireDate), TimeUnit.MILLISECONDS);
        CronScheduledFuture cronScheduledFuture = new CronScheduledFuture(future, fireDate);
        runnable.setScheduledFuture(cronScheduledFuture);
        return cronScheduledFuture;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executorService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public long nextFireInterval(Date fireDate) {
        return fireDate.getTime() - new Date().getTime();
    }

    public class CronRunnable
    implements Runnable {
        private final CronExpression cronExpression;
        private final Runnable runnable;
        private CronScheduledFuture<?> scheduledFuture;

        public CronRunnable(Runnable runnable, CronExpression cronExpression) {
            this.cronExpression = cronExpression;
            this.runnable = runnable;
        }

        public void setScheduledFuture(CronScheduledFuture<?> future) {
            this.scheduledFuture = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable ex) {
                LOGGER.error("Error running command", ex);
            }
            finally {
                Date fireDate = this.cronExpression.getNextInvalidTimeAfter(new Date());
                ScheduledFuture<?> future = ConfigurationScheduler.this.schedule(this, ConfigurationScheduler.this.nextFireInterval(fireDate), TimeUnit.MILLISECONDS);
                this.scheduledFuture.reset(future, fireDate);
            }
        }
    }
}

