/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.JobPO;
import org.apache.ibatis.annotations.Param;

public class JobMetaBaseSQLProvider {
    public String insertJobMeta(@Param(value="jobMeta") JobPO jobPO) {
        return "INSERT INTO job_run_meta (job_run_id, job_template_id, metalake_id, job_execution_id, job_run_status, job_finished_at, audit_info, current_version, last_version, deleted_at) VALUES (#{jobMeta.jobRunId}, (SELECT job_template_id FROM job_template_meta WHERE job_template_name = #{jobMeta.jobTemplateName} AND metalake_id = #{jobMeta.metalakeId} AND deleted_at = 0), #{jobMeta.metalakeId}, #{jobMeta.jobExecutionId}, #{jobMeta.jobRunStatus}, #{jobMeta.jobFinishedAt}, #{jobMeta.auditInfo}, #{jobMeta.currentVersion}, #{jobMeta.lastVersion}, #{jobMeta.deletedAt})";
    }

    public String insertJobMetaOnDuplicateKeyUpdate(@Param(value="jobMeta") JobPO jobPO) {
        return "INSERT INTO job_run_meta (job_run_id, job_template_id, metalake_id, job_execution_id, job_run_status, job_finished_at, audit_info, current_version, last_version, deleted_at) VALUES (#{jobMeta.jobRunId}, (SELECT job_template_id FROM job_template_meta WHERE job_template_name = #{jobMeta.jobTemplateName} AND metalake_id = #{jobMeta.metalakeId} AND deleted_at = 0), #{jobMeta.metalakeId}, #{jobMeta.jobExecutionId}, #{jobMeta.jobRunStatus}, #{jobMeta.jobFinishedAt}, #{jobMeta.auditInfo}, #{jobMeta.currentVersion}, #{jobMeta.lastVersion}, #{jobMeta.deletedAt}) ON DUPLICATE KEY UPDATE job_template_id = (SELECT job_template_id FROM job_template_meta WHERE job_template_name = #{jobMeta.jobTemplateName} AND metalake_id = #{jobMeta.metalakeId} AND deleted_at = 0), metalake_id = #{jobMeta.metalakeId}, job_execution_id = #{jobMeta.jobExecutionId}, job_run_status = #{jobMeta.jobRunStatus}, job_finished_at = #{jobMeta.jobFinishedAt}, audit_info = #{jobMeta.auditInfo}, current_version = #{jobMeta.currentVersion}, last_version = #{jobMeta.lastVersion}, deleted_at = #{jobMeta.deletedAt}";
    }

    public String listJobPOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return "SELECT jrm.job_run_id AS jobRunId, jtm.job_template_name AS jobTemplateName, jrm.metalake_id AS metalakeId, jrm.job_execution_id AS jobExecutionId, jrm.job_run_status AS jobRunStatus, jrm.job_finished_at AS jobFinishedAt, jrm.audit_info AS auditInfo, jrm.current_version AS currentVersion, jrm.last_version AS lastVersion, jrm.deleted_at AS deletedAt FROM job_run_meta jrm JOIN job_template_meta jtm ON jrm.job_template_id = jtm.job_template_id JOIN metalake_meta mm ON jrm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND jrm.deleted_at = 0 AND mm.deleted_at = 0 AND jtm.deleted_at = 0";
    }

    public String listJobPOsByMetalakeAndTemplate(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return "SELECT jrm.job_run_id AS jobRunId, jtm.job_template_name AS jobTemplateName, jrm.metalake_id AS metalakeId, jrm.job_execution_id AS jobExecutionId, jrm.job_run_status AS jobRunStatus, jrm.job_finished_at AS jobFinishedAt, jrm.audit_info AS auditInfo, jrm.current_version AS currentVersion, jrm.last_version AS lastVersion, jrm.deleted_at AS deletedAt FROM job_run_meta jrm JOIN job_template_meta jtm ON jrm.job_template_id = jtm.job_template_id JOIN metalake_meta mm ON jrm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND jtm.job_template_name = #{jobTemplateName} AND jrm.deleted_at = 0 AND mm.deleted_at = 0 AND jtm.deleted_at = 0";
    }

    public String selectJobPOByMetalakeAndRunId(@Param(value="metalakeName") String metalakeName, @Param(value="jobRunId") Long jobRunId) {
        return "SELECT jrm.job_run_id AS jobRunId, jtm.job_template_name AS jobTemplateName, jrm.metalake_id AS metalakeId, jrm.job_execution_id AS jobExecutionId, jrm.job_run_status AS jobRunStatus, jrm.job_finished_at AS jobFinishedAt, jrm.audit_info AS auditInfo, jrm.current_version AS currentVersion, jrm.last_version AS lastVersion, jrm.deleted_at AS deletedAt FROM job_run_meta jrm JOIN job_template_meta jtm ON jrm.job_template_id = jtm.job_template_id JOIN metalake_meta mm ON jrm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND jrm.job_run_id = #{jobRunId} AND jrm.deleted_at = 0 AND mm.deleted_at = 0 AND jtm.deleted_at = 0";
    }

    public String softDeleteJobMetaByMetalakeAndTemplate(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return "UPDATE job_run_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000.0 WHERE metalake_id = ( SELECT metalake_id FROM metalake_meta WHERE metalake_name = #{metalakeName} AND deleted_at = 0) AND job_template_id IN ( SELECT job_template_id FROM job_template_meta WHERE job_template_name = #{jobTemplateName} AND deleted_at = 0) AND deleted_at = 0";
    }

    public String softDeleteJobMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE job_run_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000.0 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String softDeleteJobMetaByRunId(@Param(value="jobRunId") Long jobRunId) {
        return "UPDATE job_run_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000.0 WHERE job_run_id = #{jobRunId} AND deleted_at = 0";
    }

    public String softDeleteJobMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline) {
        return "UPDATE job_run_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000.0 WHERE job_finished_at < #{legacyTimeline} AND job_finished_at > 0 AND deleted_at = 0";
    }

    public String deleteJobMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM job_run_meta WHERE deleted_at < #{legacyTimeline} AND deleted_at > 0 LIMIT #{limit}";
    }
}

