/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.ZooKeeperMain;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class ZooKeeperTest
extends ClientBase {
    @Test
    public void testDeleteRecursive() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v/1", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/c", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/c/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        List children = zk.getChildren("/a", false);
        Assert.assertEquals((String)"2 children - b & c should be present ", (long)children.size(), (long)2L);
        Assert.assertTrue((boolean)children.contains("b"));
        Assert.assertTrue((boolean)children.contains("c"));
        ZKUtil.deleteRecursive((ZooKeeper)zk, (String)"/a");
        Assert.assertNull((Object)zk.exists("/a", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursiveAsync() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v/1", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/c", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/c/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int i = 0; i < 50; ++i) {
            zk.create("/a/c/" + i, "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        List children = zk.getChildren("/a", false);
        Assert.assertEquals((String)"2 children - b & c should be present ", (long)children.size(), (long)2L);
        Assert.assertTrue((boolean)children.contains("b"));
        Assert.assertTrue((boolean)children.contains("c"));
        AsyncCallback.VoidCallback cb = new AsyncCallback.VoidCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResult(int rc, String path, Object ctx) {
                Object object = ctx;
                synchronized (object) {
                    ((AtomicInteger)ctx).set(4);
                    ctx.notify();
                }
            }
        };
        AtomicInteger ctx = new AtomicInteger(3);
        ZKUtil.deleteRecursive((ZooKeeper)zk, (String)"/a", (AsyncCallback.VoidCallback)cb, (Object)ctx);
        AtomicInteger atomicInteger = ctx;
        synchronized (atomicInteger) {
            ctx.wait();
        }
        Assert.assertEquals((long)4L, (long)ctx.get());
    }

    @Test
    public void testStatWhenPathDoesNotExist() throws IOException, InterruptedException {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain main = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "stat /invalidPath";
        main.cl.parseCommand(cmdstring);
        try {
            main.processZKCmd(main.cl);
            Assert.fail((String)"As Node does not exist, command should fail by throwing No Node Exception.");
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)"KeeperErrorCode = NoNode for /invalidPath", (Object)e.getMessage());
        }
    }

    @Test
    public void testParseWithExtraSpaces() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "      ls       /  ";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertEquals((String)"Spaces also considered as characters", (long)zkMain.cl.getNumArguments(), (long)2L);
        Assert.assertEquals((String)"ls is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"ls");
        Assert.assertEquals((String)"/ is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/");
    }

    @Test
    public void testCheckInvalidAcls() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create -s -e /node data ip:scheme:gggsd";
        try {
            zkMain.executeLine(cmdstring);
        }
        catch (KeeperException.InvalidACLException e) {
            Assert.fail((String)"For Invalid ACls should not throw exception");
        }
    }

    @Test
    public void testDeleteWithInvalidVersionNo() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create -s -e /node1 data ";
        String cmdstring1 = "delete /node1 2";
        zkMain.executeLine(cmdstring);
        try {
            zkMain.executeLine(cmdstring1);
        }
        catch (KeeperException.BadVersionException e) {
            Assert.fail((String)"For Invalid dataversion number should not throw exception");
        }
    }

    @Test
    public void testCliCommandsNotEchoingUsage() throws Exception {
        PrintStream systemErr = System.err;
        ByteArrayOutputStream errContent = new ByteArrayOutputStream();
        System.setErr(new PrintStream(errContent));
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmd1 = "printwatches";
        zkMain.executeLine(cmd1);
        String cmd2 = "history";
        zkMain.executeLine(cmd2);
        String cmd3 = "redo";
        zkMain.executeLine(cmd3);
        System.setErr(systemErr);
        if (errContent.toString().contains("ZooKeeper -server host:port cmd args")) {
            Assert.fail((String)"CLI commands (history, redo, connect, printwatches) display usage info!");
        }
    }

    @Test
    public void testParseWithQuotes() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        for (String quoteChar : new String[]{"'", "\""}) {
            String cmdstring = String.format("create /node %1$squoted data%1$s", quoteChar);
            zkMain.cl.parseCommand(cmdstring);
            Assert.assertEquals((String)"quotes combine arguments", (long)zkMain.cl.getNumArguments(), (long)3L);
            Assert.assertEquals((String)"create is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"create");
            Assert.assertEquals((String)"/node is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/node");
            Assert.assertEquals((String)"quoted data is not taken as third argument", (Object)zkMain.cl.getCmdArgument(2), (Object)"quoted data");
        }
    }

    @Test
    public void testParseWithMixedQuotes() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        for (String[] quoteChars : new String[][]{{"'", "\""}, {"\"", "'"}}) {
            String outerQuotes = quoteChars[0];
            String innerQuotes = quoteChars[1];
            String cmdstring = String.format("create /node %1$s%2$squoted data%2$s%1$s", outerQuotes, innerQuotes);
            zkMain.cl.parseCommand(cmdstring);
            Assert.assertEquals((String)"quotes combine arguments", (long)zkMain.cl.getNumArguments(), (long)3L);
            Assert.assertEquals((String)"create is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"create");
            Assert.assertEquals((String)"/node is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/node");
            Assert.assertEquals((String)"quoted data is not taken as third argument", (Object)zkMain.cl.getCmdArgument(2), (Object)(innerQuotes + "quoted data" + innerQuotes));
        }
    }

    @Test
    public void testParseWithEmptyQuotes() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create /node ''";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertEquals((String)"empty quotes should produce arguments", (long)zkMain.cl.getNumArguments(), (long)3L);
        Assert.assertEquals((String)"create is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"create");
        Assert.assertEquals((String)"/node is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/node");
        Assert.assertEquals((String)"empty string is not taken as third argument", (Object)zkMain.cl.getCmdArgument(2), (Object)"");
    }

    @Test
    public void testParseWithMultipleQuotes() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmdstring = "create /node '' ''";
        zkMain.cl.parseCommand(cmdstring);
        Assert.assertEquals((String)"expected 5 arguments", (long)zkMain.cl.getNumArguments(), (long)4L);
        Assert.assertEquals((String)"create is not taken as first argument", (Object)zkMain.cl.getCmdArgument(0), (Object)"create");
        Assert.assertEquals((String)"/node is not taken as second argument", (Object)zkMain.cl.getCmdArgument(1), (Object)"/node");
        Assert.assertEquals((String)"empty string is not taken as third argument", (Object)zkMain.cl.getCmdArgument(2), (Object)"");
        Assert.assertEquals((String)"empty string is not taken as fourth argument", (Object)zkMain.cl.getCmdArgument(3), (Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedoWithNegativeCmdNumber() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ZooKeeperMain zkMain = new ZooKeeperMain((ZooKeeper)zk);
        String cmd1 = "redo -1";
        PrintStream systemOut = System.out;
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        try {
            zkMain.executeLine(cmd1);
            Assert.assertEquals((Object)"Command index out of range", (Object)outContent.toString().trim());
        }
        finally {
            System.setOut(systemOut);
        }
    }
}

