/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.jute.Record;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.persistence.FilePadding;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnLogTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FileTxnLogTest.class);
    private static final int KB = 1024;

    @Test
    public void testInvalidPreallocSize() {
        Assert.assertEquals((String)"file should not be padded", (long)10240L, (long)FilePadding.calculateFileSizeWithPadding((long)7168L, (long)10240L, (long)0L));
        Assert.assertEquals((String)"file should not be padded", (long)10240L, (long)FilePadding.calculateFileSizeWithPadding((long)7168L, (long)10240L, (long)-1L));
    }

    @Test
    public void testCalculateFileSizeWithPaddingWhenNotToCurrentSize() {
        Assert.assertEquals((String)"file should not be padded", (long)10240L, (long)FilePadding.calculateFileSizeWithPadding((long)5120L, (long)10240L, (long)10240L));
    }

    @Test
    public void testCalculateFileSizeWithPaddingWhenCloseToCurrentSize() {
        Assert.assertEquals((String)"file should be padded an additional 10 KB", (long)20480L, (long)FilePadding.calculateFileSizeWithPadding((long)7168L, (long)10240L, (long)10240L));
    }

    @Test
    public void testFileSizeGreaterThanPosition() {
        Assert.assertEquals((String)"file should be padded to 40 KB", (long)40960L, (long)FilePadding.calculateFileSizeWithPadding((long)31744L, (long)10240L, (long)10240L));
    }

    @Test
    public void testPreAllocSizeSmallerThanTxnData() throws IOException {
        File logDir = ClientBase.createTmpDir();
        FileTxnLog fileTxnLog = new FileTxnLog(logDir);
        int preAllocSize = 512000;
        FilePadding.setPreallocSize((long)512000L);
        byte[] data = new byte[1024000];
        Arrays.fill(data, (byte)-1);
        fileTxnLog.append(new TxnHeader(1L, 1, 1L, 1L, 1), (Record)new CreateTxn("/testPreAllocSizeSmallerThanTxnData1", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0));
        fileTxnLog.commit();
        fileTxnLog.append(new TxnHeader(1L, 1, 2L, 2L, 1), (Record)new CreateTxn("/testPreAllocSizeSmallerThanTxnData2", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0));
        fileTxnLog.commit();
        fileTxnLog.close();
        FileTxnLog.FileTxnIterator fileTxnIterator = new FileTxnLog.FileTxnIterator(logDir, 0L);
        CreateTxn createTxn = (CreateTxn)fileTxnIterator.getTxn();
        Assert.assertTrue((boolean)Arrays.equals(createTxn.getData(), data));
        fileTxnIterator.next();
        createTxn = (CreateTxn)fileTxnIterator.getTxn();
        Assert.assertTrue((boolean)Arrays.equals(createTxn.getData(), new byte[0]));
    }

    @Test
    public void testSetPreallocSize() {
        long customPreallocSize = 10101L;
        FileTxnLog.setPreallocSize((long)customPreallocSize);
        Assert.assertThat((Object)FilePadding.getPreAllocSize(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)customPreallocSize)));
    }

    @Test
    public void testSyncThresholdExceedCount() throws IOException {
        System.setProperty("zookeeper.fsync.warningthresholdms", "-1");
        ServerStats.Provider providerMock = (ServerStats.Provider)Mockito.mock(ServerStats.Provider.class);
        ServerStats serverStats = new ServerStats(providerMock);
        File logDir = ClientBase.createTmpDir();
        FileTxnLog fileTxnLog = new FileTxnLog(logDir);
        fileTxnLog.setServerStats(serverStats);
        Assert.assertEquals((long)0L, (long)serverStats.getFsyncThresholdExceedCount());
        for (int i = 0; i < 50; ++i) {
            fileTxnLog.append(new TxnHeader(1L, 1, 1L, 1L, 1), (Record)new CreateTxn("/testFsyncThresholdCountIncreased", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0));
            fileTxnLog.commit();
        }
    }
}

