/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.auth.QuorumAuthTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class QuorumDigestAuthTest
extends QuorumAuthTestBase {
    private ZooKeeper zk;

    @After
    public void tearDown() throws Exception {
        for (QuorumPeerTestBase.MainThread mainThread : this.mt) {
            mainThread.shutdown();
            mainThread.deleteBaseDir();
        }
        if (this.zk != null) {
            this.zk.close();
        }
    }

    @AfterClass
    public static void cleanup() {
        QuorumDigestAuthTest.cleanupJaasConfig();
    }

    @Test(timeout=30000L)
    public void testValidCredentials() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        String connectStr = this.startQuorum(3, authConfigs, 3, false);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        this.zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            this.zk.create("/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    @Test(timeout=30000L)
    public void testSaslNotRequiredWithInvalidCredentials() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.learner.saslLoginContext", "QuorumLearnerInvalid");
        authConfigs.put("quorum.auth.enableSasl", "false");
        authConfigs.put("quorum.auth.serverRequireSasl", "false");
        String connectStr = this.startQuorum(3, authConfigs, 3, false);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        this.zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            this.zk.create("/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    @Test(timeout=30000L)
    public void testSaslRequiredInvalidCredentials() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.learner.saslLoginContext", "QuorumLearnerInvalid");
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        int serverCount = 2;
        int[] clientPorts = this.startQuorum(serverCount, 0, new StringBuilder(), authConfigs, serverCount, false);
        for (int i = 0; i < serverCount; ++i) {
            boolean waitForServerUp = ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], 5000L);
            Assert.assertFalse((String)"Shouldn't start server with invalid credentials", (boolean)waitForServerUp);
        }
    }

    @Test(timeout=10000L)
    public void testEnableQuorumServerRequireSaslWithoutQuorumLearnerRequireSasl() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.learner.saslLoginContext", "QuorumLearner");
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "false");
        QuorumPeerTestBase.MainThread mthread = new QuorumPeerTestBase.MainThread(1, PortAssignment.unique(), "", authConfigs);
        String[] args = new String[]{mthread.getConfFile().toString()};
        try {
            new QuorumPeerMain(){

                protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
                    super.initializeAndRun(args);
                }
            }.initializeAndRun(args);
            Assert.fail((String)"Must throw exception as quorumpeer learner is not enabled!");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testEnableQuorumAuthenticationConfigurations() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.learner.saslLoginContext", "QuorumLearner");
        authConfigs.put("quorum.auth.enableSasl", "false");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "false");
        QuorumPeerTestBase.MainThread mthread = new QuorumPeerTestBase.MainThread(1, PortAssignment.unique(), "", authConfigs);
        String[] args = new String[]{mthread.getConfFile().toString()};
        try {
            new QuorumPeerMain(){

                protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
                    super.initializeAndRun(args);
                }
            }.initializeAndRun(args);
            Assert.fail((String)"Must throw exception as quorum sasl is not enabled!");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
        authConfigs.put("quorum.auth.serverRequireSasl", "false");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        try {
            new QuorumPeerMain(){

                protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
                    super.initializeAndRun(args);
                }
            }.initializeAndRun(args);
            Assert.fail((String)"Must throw exception as quorum sasl is not enabled!");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testObserverWithValidCredentials() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        int totalServerCount = 5;
        int observerCount = 2;
        String connectStr = this.startQuorum(totalServerCount, observerCount, authConfigs, totalServerCount);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        this.zk = new ZooKeeper(connectStr.toString(), ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        this.zk.create("/myTestRoot", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    @Test(timeout=30000L)
    public void testNonAuthEnabledObserverJoiningAuthEnabledQuorum() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        int totalServerCount = 3;
        String connectStr = this.startQuorum(totalServerCount, authConfigs, totalServerCount, false);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        this.zk = new ZooKeeper(connectStr.toString(), ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        this.zk.create("/myTestRoot", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        String quorumCfgSection = ((QuorumPeerTestBase.MainThread)this.mt.get(0)).getQuorumCfgSection();
        int observerMyid = totalServerCount + 1;
        StringBuilder newObsCfgSection = new StringBuilder(quorumCfgSection);
        newObsCfgSection.append("\n");
        newObsCfgSection.append(String.format("server.%d=localhost:%d:%d:observer", observerMyid, PortAssignment.unique(), PortAssignment.unique()));
        newObsCfgSection.append("\npeerType=observer");
        newObsCfgSection.append("\n");
        int clientPort = PortAssignment.unique();
        newObsCfgSection.append("127.0.0.1:" + clientPort);
        QuorumPeerTestBase.MainThread mthread = new QuorumPeerTestBase.MainThread(observerMyid, clientPort, newObsCfgSection.toString());
        this.mt.add(mthread);
        mthread.start();
        boolean waitForServerUp = ClientBase.waitForServerUp("127.0.0.1:" + clientPort, 5000L);
        Assert.assertFalse((String)"Non-auth enabled Observer shouldn't be able join auth-enabled quorum", (boolean)waitForServerUp);
        this.zk.create("/myTestRoot", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    @Test(timeout=30000L)
    public void testRelectionWithValidCredentials() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        String connectStr = this.startQuorum(3, authConfigs, 3, false);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        this.zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        this.zk.create("/myTestRoot", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        watcher.reset();
        QuorumPeer leaderQP = this.getLeaderQuorumPeer(this.mt);
        LOG.info("Shutdown Leader sid:{} to trigger quorum leader-election", (Object)leaderQP.getId());
        this.shutdownQP(leaderQP);
        QuorumPeer newLeaderQP = this.waitForLeader();
        Assert.assertNotNull((String)"New leader must have been elected by now", (Object)newLeaderQP);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        this.zk.create("/myTestRoot", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    private QuorumPeer waitForLeader() throws InterruptedException {
        QuorumPeer newLeaderQP = null;
        for (int retryCnt = 0; retryCnt < 30; --retryCnt) {
            newLeaderQP = this.getLeaderQuorumPeer(this.mt);
            if (newLeaderQP != null) {
                LOG.info("Number of retries:{} to findout new Leader", (Object)retryCnt);
                break;
            }
            Thread.sleep(500L);
        }
        return newLeaderQP;
    }

    private void shutdownQP(QuorumPeer qp) throws InterruptedException {
        Assert.assertNotNull((String)"QuorumPeer doesn't exist!", (Object)qp);
        qp.shutdown();
        for (int retryCnt = 30; retryCnt > 0; --retryCnt) {
            if (qp.getPeerState() == QuorumPeer.ServerState.LOOKING) {
                LOG.info("Number of retries:{} to change the server state to {}", (Object)retryCnt, (Object)QuorumPeer.ServerState.LOOKING);
                break;
            }
            Thread.sleep(500L);
        }
        Assert.assertEquals((String)"After shutdown, QuorumPeer should change its state to LOOKING", (Object)QuorumPeer.ServerState.LOOKING, (Object)qp.getPeerState());
    }

    private QuorumPeer getLeaderQuorumPeer(List<QuorumPeerTestBase.MainThread> mtList) {
        for (QuorumPeerTestBase.MainThread mt : mtList) {
            QuorumPeer quorumPeer = mt.getQuorumPeer();
            if (null == quorumPeer || QuorumPeer.ServerState.LEADING != quorumPeer.getPeerState()) continue;
            return quorumPeer;
        }
        return null;
    }

    static {
        String jaasEntries = new String("QuorumServer {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       user_test=\"mypassword\";\n};\nQuorumLearner {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"test\"\n       password=\"mypassword\";\n};\nQuorumLearnerInvalid {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"test\"\n       password=\"invalid\";\n};\n");
        QuorumDigestAuthTest.setupJaasConfig(jaasEntries);
    }
}

