/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.gravitino.iceberg.common.authentication.AuthenticationConfig;
import org.apache.gravitino.iceberg.common.authentication.SupportsKerberos;
import org.apache.gravitino.iceberg.common.authentication.kerberos.KerberosClient;
import org.apache.gravitino.iceberg.common.utils.CaffeineSchedulerExtractorUtils;
import org.apache.gravitino.iceberg.common.utils.IcebergHiveCachedClientPool;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosableHiveCatalog
extends HiveCatalog
implements Closeable,
SupportsKerberos {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClosableHiveCatalog.class);
    private final List<Closeable> resources = Lists.newArrayList();
    private KerberosClient kerberosClient;

    public void addResource(Closeable resource) {
        this.resources.add(resource);
    }

    public void initialize(String inputName, Map<String, String> properties) {
        super.initialize(inputName, properties);
        AuthenticationConfig authenticationConfig = new AuthenticationConfig(properties);
        if (authenticationConfig.isKerberosAuth()) {
            this.kerberosClient = this.initKerberosClient();
        }
        try {
            this.resetIcebergHiveClientPool();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to reset IcebergHiveClientPool", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.kerberosClient != null) {
            try {
                this.kerberosClient.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close KerberosClient", (Throwable)e);
            }
        }
        this.closeInternalClientPool();
        this.resources.forEach(resource -> {
            try {
                if (resource != null) {
                    resource.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close resource: {}", resource, (Object)e);
            }
        });
    }

    @Override
    public <R> R doKerberosOperations(SupportsKerberos.Executable<R> executable) throws Throwable {
        Map properties = this.properties();
        AuthenticationConfig authenticationConfig = new AuthenticationConfig(properties);
        String proxyKerberosPrincipalName = PrincipalUtils.getCurrentPrincipal().getName();
        String finalPrincipalName = !proxyKerberosPrincipalName.contains("@") ? String.format("%s@%s", proxyKerberosPrincipalName, this.kerberosClient.getRealm()) : proxyKerberosPrincipalName;
        UserGroupInformation realUser = authenticationConfig.isImpersonationEnabled() ? UserGroupInformation.createProxyUser((String)finalPrincipalName, (UserGroupInformation)this.kerberosClient.getLoginUser()) : this.kerberosClient.getLoginUser();
        try {
            ClientPool newClientPool = (ClientPool)FieldUtils.readField((Object)this, (String)"clients", (boolean)true);
            this.kerberosClient.getLoginUser().doAs(() -> {
                String token = (String)newClientPool.run(client -> client.getDelegationToken(finalPrincipalName, this.kerberosClient.getLoginUser().getShortUserName()));
                Token delegationToken = new Token();
                delegationToken.decodeFromUrlString(token);
                realUser.addToken(delegationToken);
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get delegation token for principal: " + finalPrincipalName, e);
        }
        return (R)realUser.doAs(() -> {
            try {
                return executable.execute();
            }
            catch (Throwable e) {
                if (RuntimeException.class.isAssignableFrom(e.getClass())) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Failed to invoke method", e);
            }
        });
    }

    private ClientPool<IMetaStoreClient, TException> resetIcebergHiveClientPool() throws IllegalAccessException {
        Object oldPool = FieldUtils.readField((Object)this, (String)"clients", (boolean)true);
        IcebergHiveCachedClientPool newClientPool = new IcebergHiveCachedClientPool(this.getConf(), this.properties());
        FieldUtils.writeField((Object)this, (String)"clients", (Object)newClientPool, (boolean)true);
        if (oldPool != null) {
            if (oldPool instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)oldPool).close();
                    LOGGER.info("Successfully closed old Hive client pool");
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to close old Hive client pool", (Throwable)e);
                }
            }
            try {
                this.shutdownIcebergCachedClientPoolScheduler(oldPool);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to shutdown scheduler in old CachedClientPool, may cause minor resource leak", (Throwable)e);
            }
        }
        return newClientPool;
    }

    @VisibleForTesting
    void shutdownIcebergCachedClientPoolScheduler(Object clientPool) {
        try {
            Object cache = FieldUtils.readField((Object)clientPool, (String)"clientPoolCache", (boolean)true);
            if (cache == null) {
                LOGGER.debug("clientPoolCache is null, no scheduler to shutdown");
                return;
            }
            ScheduledExecutorService executor = CaffeineSchedulerExtractorUtils.extractSchedulerExecutor(cache);
            if (executor != null) {
                LOGGER.info("Shutting down scheduler thread pool from old CachedClientPool");
                executor.shutdownNow();
            } else {
                LOGGER.debug("Could not extract scheduler executor from cache");
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.debug("Failed to access clientPoolCache field", (Throwable)e);
        }
    }

    private void closeInternalClientPool() {
        try {
            Field clientsField = HiveCatalog.class.getDeclaredField("clients");
            clientsField.setAccessible(true);
            Object clientPool = clientsField.get(this);
            if (clientPool != null && clientPool instanceof AutoCloseable && !(clientPool instanceof IcebergHiveCachedClientPool)) {
                ((AutoCloseable)clientPool).close();
                LOGGER.info("Closed HiveCatalog internal client pool: {}", (Object)clientPool.getClass().getSimpleName());
            }
        }
        catch (NoSuchFieldException e) {
            LOGGER.warn("Could not find 'clients' field in HiveCatalog, skipping cleanup", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to close HiveCatalog internal client pool", (Throwable)e);
        }
    }

    private KerberosClient initKerberosClient() {
        try {
            KerberosClient kerberosClient = new KerberosClient(this.properties(), this.getConf());
            String catalogUUID = this.properties().getOrDefault("catalog_uuid", "0");
            File keytabFile = kerberosClient.saveKeyTabFileFromUri(Long.parseLong(catalogUUID));
            kerberosClient.login(keytabFile.getAbsolutePath());
            return kerberosClient;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to login with kerberos", e);
        }
    }

    public List<Closeable> getResources() {
        return this.resources;
    }
}

