/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.Credential;

public class GCSTokenCredential
implements Credential {
    public static final String GCS_TOKEN_CREDENTIAL_TYPE = "gcs-token";
    public static final String GCS_TOKEN_NAME = "token";
    private String token;
    private long expireTimeInMs;

    public GCSTokenCredential(String token, long expireTimeInMs) {
        this.validate(token, expireTimeInMs);
        this.token = token;
        this.expireTimeInMs = expireTimeInMs;
    }

    public GCSTokenCredential() {
    }

    @Override
    public String credentialType() {
        return GCS_TOKEN_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return this.expireTimeInMs;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder().put((Object)GCS_TOKEN_NAME, (Object)this.token).build();
    }

    @Override
    public void initialize(Map<String, String> credentialInfo, long expireTimeInMs) {
        String token = credentialInfo.get(GCS_TOKEN_NAME);
        this.validate(token, expireTimeInMs);
        this.token = token;
        this.expireTimeInMs = expireTimeInMs;
    }

    public String token() {
        return this.token;
    }

    private void validate(String token, long expireTimeInMs) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)token), (Object)"GCS session token should not be empty");
        Preconditions.checkArgument((expireTimeInMs > 0L ? 1 : 0) != 0, (Object)"The expire time of GcsTokenCredential should great than 0");
    }
}

