/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.AuditCommand;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelCatalog;

public class ModelAudit
extends AuditCommand {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String model;

    public ModelAudit(CommandContext context, String metalake, String catalog, String schema, String model) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.model = model;
    }

    @Override
    public void handle() {
        Model result;
        NameIdentifier name = NameIdentifier.of(this.schema, this.model);
        try (GravitinoClient client = this.buildClient(this.metalake);){
            ModelCatalog modelCatalog = client.loadCatalog(this.catalog).asModelCatalog();
            result = modelCatalog.getModel(name);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
            return;
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
            return;
        }
        catch (NoSuchModelException err) {
            this.exitWithError("Unknown model name.");
            return;
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
            return;
        }
        if (result != null) {
            this.displayAuditInfo(result.auditInfo());
        }
    }
}

