/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.ObjectMapperProvider;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.responses.OAuth2TokenResponse;
import org.apache.gravitino.json.JsonUtils;

class OAuth2ClientUtil {
    public static final String SCOPE = "scope";
    private static final Splitter CREDENTIAL_SPLITTER = Splitter.on(":").limit(2).trimResults();
    private static final String GRANT_TYPE = "grant_type";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    public static final String INVALID_REQUEST_ERROR = "invalid_request";
    public static final String INVALID_CLIENT_ERROR = "invalid_client";
    public static final String INVALID_GRANT_ERROR = "invalid_grant";
    public static final String UNAUTHORIZED_CLIENT_ERROR = "unauthorized_client";
    public static final String UNSUPPORTED_GRANT_TYPE_ERROR = "unsupported_grant_type";
    public static final String INVALID_SCOPE_ERROR = "invalid_scope";
    private static final Joiner SCOPE_JOINER = Joiner.on(" ");

    private OAuth2ClientUtil() {
    }

    public static OAuth2TokenResponse fetchToken(RESTClient client, Map<String, String> headers, String credential, String scope, String path) {
        Map<String, String> request = OAuth2ClientUtil.clientCredentialsRequest(credential, scope != null ? ImmutableList.of(scope) : ImmutableList.of());
        OAuth2TokenResponse response = client.postForm(path, request, OAuth2TokenResponse.class, headers, ErrorHandlers.oauthErrorHandler());
        response.validate();
        return response;
    }

    private static Pair<String, String> parseCredential(String credential) {
        Preconditions.checkArgument(credential != null, "Invalid credential: null");
        List<String> parts = CREDENTIAL_SPLITTER.splitToList(credential);
        switch (parts.size()) {
            case 2: {
                return Pair.of(parts.get(0), parts.get(1));
            }
            case 1: {
                return Pair.of(null, parts.get(0));
            }
        }
        throw new IllegalArgumentException("Invalid credential: " + credential);
    }

    private static Map<String, String> clientCredentialsRequest(String credential, List<String> scopes) {
        Pair<String, String> credentialPair = OAuth2ClientUtil.parseCredential(credential);
        return OAuth2ClientUtil.clientCredentialsRequest(credentialPair.getLeft(), credentialPair.getRight(), scopes);
    }

    private static Map<String, String> clientCredentialsRequest(String clientId, String clientSecret, List<String> scopes) {
        ImmutableMap.Builder<String, String> formData = ImmutableMap.builder();
        formData.put(GRANT_TYPE, CLIENT_CREDENTIALS);
        if (clientId != null) {
            formData.put(CLIENT_ID, clientId);
        }
        formData.put(CLIENT_SECRET, clientSecret);
        formData.put(SCOPE, OAuth2ClientUtil.toScope(scopes));
        return formData.build();
    }

    static Long expiresAtMillis(String token) {
        JsonNode node;
        if (null == token) {
            return null;
        }
        List<String> parts = Splitter.on('.').splitToList(token);
        if (parts.size() != 3) {
            return null;
        }
        try {
            node = ObjectMapperProvider.objectMapper().readTree(Base64.getUrlDecoder().decode(parts.get(1)));
        }
        catch (IOException e) {
            return null;
        }
        String property = "exp";
        if (!node.has(property) || node.get(property).isNull()) {
            return null;
        }
        return TimeUnit.SECONDS.toMillis(JsonUtils.getLong(property, node));
    }

    public static String toScope(Iterable<String> scopes) {
        return SCOPE_JOINER.join(scopes);
    }
}

