/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.DistributionDTO;
import org.apache.gravitino.dto.rel.SortOrderDTO;
import org.apache.gravitino.dto.rel.indexes.IndexDTO;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;

public class TableDTO
implements Table {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="columns")
    private ColumnDTO[] columns;
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="audit")
    private AuditDTO audit;
    @JsonProperty(value="distribution")
    private DistributionDTO distribution;
    @JsonProperty(value="sortOrders")
    private SortOrderDTO[] sortOrders;
    @JsonProperty(value="partitioning")
    private Partitioning[] partitioning;
    @JsonProperty(value="indexes")
    private IndexDTO[] indexes;

    private TableDTO() {
    }

    private TableDTO(String name, String comment, ColumnDTO[] columns, Map<String, String> properties, AuditDTO audit, Partitioning[] partitioning, DistributionDTO distribution, SortOrderDTO[] sortOrderDTOs, IndexDTO[] indexes) {
        this.name = name;
        this.comment = comment;
        this.columns = columns;
        this.properties = properties;
        this.audit = audit;
        this.distribution = distribution;
        this.sortOrders = sortOrderDTOs;
        this.partitioning = partitioning;
        this.indexes = indexes;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Column[] columns() {
        return this.columns;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public AuditDTO auditInfo() {
        return this.audit;
    }

    @Override
    public Transform[] partitioning() {
        return this.partitioning;
    }

    @Override
    public SortOrder[] sortOrder() {
        return this.sortOrders;
    }

    @Override
    public Distribution distribution() {
        return this.distribution;
    }

    @Override
    public Index[] index() {
        return this.indexes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDTO)) {
            return false;
        }
        TableDTO other = (TableDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        if (!Arrays.deepEquals(this.columns, other.columns)) {
            return false;
        }
        Map<String, String> this$properties = this.properties;
        Map<String, String> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        AuditDTO this$audit = this.audit;
        AuditDTO other$audit = other.audit;
        if (this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit)) {
            return false;
        }
        DistributionDTO this$distribution = this.distribution;
        DistributionDTO other$distribution = other.distribution;
        if (this$distribution == null ? other$distribution != null : !((Object)this$distribution).equals(other$distribution)) {
            return false;
        }
        if (!Arrays.deepEquals(this.sortOrders, other.sortOrders)) {
            return false;
        }
        if (!Arrays.deepEquals(this.partitioning, other.partitioning)) {
            return false;
        }
        return Arrays.deepEquals(this.indexes, other.indexes);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.columns);
        Map<String, String> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        AuditDTO $audit = this.audit;
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        DistributionDTO $distribution = this.distribution;
        result = result * 59 + ($distribution == null ? 43 : ((Object)$distribution).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.sortOrders);
        result = result * 59 + Arrays.deepHashCode(this.partitioning);
        result = result * 59 + Arrays.deepHashCode(this.indexes);
        return result;
    }

    public static class Builder<S extends Builder> {
        protected String name;
        protected String comment;
        protected ColumnDTO[] columns;
        protected Map<String, String> properties;
        protected AuditDTO audit;
        protected SortOrderDTO[] sortOrderDTOs;
        protected DistributionDTO distributionDTO;
        protected Partitioning[] Partitioning;
        protected IndexDTO[] indexes;

        private Builder() {
        }

        public S withName(String name) {
            this.name = name;
            return (S)this;
        }

        public S withComment(String comment) {
            this.comment = comment;
            return (S)this;
        }

        public S withColumns(ColumnDTO[] columns) {
            this.columns = columns;
            return (S)this;
        }

        public S withProperties(Map<String, String> properties) {
            this.properties = properties;
            return (S)this;
        }

        public S withAudit(AuditDTO audit) {
            this.audit = audit;
            return (S)this;
        }

        public S withDistribution(DistributionDTO distributionDTO) {
            this.distributionDTO = distributionDTO;
            return (S)this;
        }

        public S withSortOrders(SortOrderDTO[] sortOrderDTOs) {
            this.sortOrderDTOs = sortOrderDTOs;
            return (S)this;
        }

        public S withPartitioning(Partitioning[] Partitioning2) {
            this.Partitioning = Partitioning2;
            return (S)this;
        }

        public S withIndex(IndexDTO[] indexes) {
            this.indexes = indexes;
            return (S)this;
        }

        public TableDTO build() {
            Preconditions.checkArgument(this.name != null && !this.name.isEmpty(), "name cannot be null or empty");
            Preconditions.checkArgument(this.audit != null, "audit cannot be null");
            return new TableDTO(this.name, this.comment, this.columns, this.properties, this.audit, this.Partitioning, this.distributionDTO, this.sortOrderDTOs, this.indexes);
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

