/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.model.ModelChange;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RenameModelRequest.class, name="rename"), @JsonSubTypes.Type(value=RemoveModelPropertyRequest.class, name="removeProperty"), @JsonSubTypes.Type(value=SetModelPropertyRequest.class, name="setProperty"), @JsonSubTypes.Type(value=UpdateModelCommentRequest.class, name="updateComment")})
public interface ModelUpdateRequest
extends RESTRequest {
    public ModelChange modelChange();

    public static class UpdateModelCommentRequest
    implements ModelUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        @Override
        public ModelChange modelChange() {
            return ModelChange.updateComment(this.newComment);
        }

        @Override
        public void validate() throws IllegalArgumentException {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateModelCommentRequest)) {
                return false;
            }
            UpdateModelCommentRequest other = (UpdateModelCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateModelCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public UpdateModelCommentRequest(String newComment) {
            this.newComment = newComment;
        }

        public UpdateModelCommentRequest() {
            this.newComment = null;
        }

        public String toString() {
            return "ModelUpdateRequest.UpdateModelCommentRequest(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }

    public static class RemoveModelPropertyRequest
    implements ModelUpdateRequest {
        @JsonProperty(value="property")
        private final String property;

        @Override
        public ModelChange modelChange() {
            return ModelChange.removeProperty(this.property);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.property), "\"property\" field is required and cannot be empty");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveModelPropertyRequest)) {
                return false;
            }
            RemoveModelPropertyRequest other = (RemoveModelPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveModelPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public RemoveModelPropertyRequest(String property) {
            this.property = property;
        }

        public RemoveModelPropertyRequest() {
            this.property = null;
        }

        public String toString() {
            return "ModelUpdateRequest.RemoveModelPropertyRequest(property=" + this.getProperty() + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class SetModelPropertyRequest
    implements ModelUpdateRequest {
        @JsonProperty(value="property")
        private final String property;
        @JsonProperty(value="value")
        private final String value;

        @Override
        public ModelChange modelChange() {
            return ModelChange.setProperty(this.property, this.value);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.property), "\"property\" field is required and cannot be empty");
            Preconditions.checkArgument(this.value != null, "\"value\" field is required and cannot be null");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetModelPropertyRequest)) {
                return false;
            }
            SetModelPropertyRequest other = (SetModelPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetModelPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public SetModelPropertyRequest(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public SetModelPropertyRequest() {
            this.property = null;
            this.value = null;
        }

        public String toString() {
            return "ModelUpdateRequest.SetModelPropertyRequest(property=" + this.getProperty() + ", value=" + this.getValue() + ")";
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class RenameModelRequest
    implements ModelUpdateRequest {
        @JsonProperty(value="newName")
        private final String newName;

        @Override
        public ModelChange modelChange() {
            return ModelChange.rename(this.newName);
        }

        public RenameModelRequest(String newName) {
            this.newName = newName;
        }

        public RenameModelRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.newName), "\"newName\" field is required and cannot be empty");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameModelRequest)) {
                return false;
            }
            RenameModelRequest other = (RenameModelRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenameModelRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        public String toString() {
            return "ModelUpdateRequest.RenameModelRequest(newName=" + this.getNewName() + ")";
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

