/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.BlobFile;
import com.lancedb.lance.Branch;
import com.lancedb.lance.Fragment;
import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.FragmentOperation;
import com.lancedb.lance.JniLoader;
import com.lancedb.lance.LockManager;
import com.lancedb.lance.OpenDatasetBuilder;
import com.lancedb.lance.ReadOptions;
import com.lancedb.lance.Ref;
import com.lancedb.lance.SqlQuery;
import com.lancedb.lance.Tag;
import com.lancedb.lance.Transaction;
import com.lancedb.lance.Version;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.compaction.CompactionOptions;
import com.lancedb.lance.index.IndexParams;
import com.lancedb.lance.index.IndexType;
import com.lancedb.lance.io.StorageOptionsProvider;
import com.lancedb.lance.ipc.DataStatistics;
import com.lancedb.lance.ipc.LanceScanner;
import com.lancedb.lance.ipc.ScanOptions;
import com.lancedb.lance.merge.MergeInsertParams;
import com.lancedb.lance.merge.MergeInsertResult;
import com.lancedb.lance.operation.UpdateConfig;
import com.lancedb.lance.operation.UpdateMap;
import com.lancedb.lance.schema.ColumnAlteration;
import com.lancedb.lance.schema.LanceSchema;
import com.lancedb.lance.schema.SqlExpressions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public class Dataset
implements Closeable {
    private long nativeDatasetHandle;
    private BufferAllocator allocator;
    private boolean selfManagedAllocator = false;
    private final LockManager lockManager = new LockManager();

    private Dataset() {
    }

    public static Dataset create(BufferAllocator allocator, String path, Schema schema, WriteParams params) {
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkNotNull((Object)params);
        try (ArrowSchema arrowSchema = ArrowSchema.allocateNew((BufferAllocator)allocator);){
            Data.exportSchema((BufferAllocator)allocator, (Schema)schema, null, (ArrowSchema)arrowSchema);
            Dataset dataset = Dataset.createWithFfiSchema(arrowSchema.memoryAddress(), path, params.getMaxRowsPerFile(), params.getMaxRowsPerGroup(), params.getMaxBytesPerFile(), params.getMode(), params.getEnableStableRowIds(), params.getDataStorageVersion(), params.getStorageOptions());
            dataset.allocator = allocator;
            Dataset dataset2 = dataset;
            return dataset2;
        }
    }

    public static Dataset create(BufferAllocator allocator, ArrowArrayStream stream, String path, WriteParams params) {
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)params);
        Dataset dataset = Dataset.createWithFfiStream(stream.memoryAddress(), path, params.getMaxRowsPerFile(), params.getMaxRowsPerGroup(), params.getMaxBytesPerFile(), params.getMode(), params.getEnableStableRowIds(), params.getDataStorageVersion(), params.getStorageOptions());
        dataset.allocator = allocator;
        return dataset;
    }

    private static native Dataset createWithFfiSchema(long var0, String var2, Optional<Integer> var3, Optional<Integer> var4, Optional<Long> var5, Optional<String> var6, Optional<Boolean> var7, Optional<String> var8, Map<String, String> var9);

    private static native Dataset createWithFfiStream(long var0, String var2, Optional<Integer> var3, Optional<Integer> var4, Optional<Long> var5, Optional<String> var6, Optional<Boolean> var7, Optional<String> var8, Map<String, String> var9);

    public static Dataset open(String path) {
        return Dataset.open((BufferAllocator)new RootAllocator(Long.MAX_VALUE), true, path, new ReadOptions.Builder().build());
    }

    public static Dataset open(String path, ReadOptions options) {
        return Dataset.open((BufferAllocator)new RootAllocator(Long.MAX_VALUE), true, path, options);
    }

    public static Dataset open(String path, BufferAllocator allocator) {
        return Dataset.open(allocator, path, new ReadOptions.Builder().build());
    }

    public static Dataset open(BufferAllocator allocator, String path, ReadOptions options) {
        return Dataset.open(allocator, false, path, options);
    }

    static Dataset open(BufferAllocator allocator, boolean selfManagedAllocator, String path, ReadOptions options) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)options);
        Dataset dataset = Dataset.openNative(path, options.getVersion(), options.getBlockSize(), options.getIndexCacheSizeBytes(), options.getMetadataCacheSizeBytes(), options.getStorageOptions(), options.getSerializedManifest(), options.getStorageOptionsProvider(), options.getS3CredentialsRefreshOffsetSeconds());
        dataset.allocator = allocator;
        dataset.selfManagedAllocator = selfManagedAllocator;
        return dataset;
    }

    private static native Dataset openNative(String var0, Optional<Integer> var1, Optional<Integer> var2, long var3, long var5, Map<String, String> var7, Optional<ByteBuffer> var8, Optional<StorageOptionsProvider> var9, Optional<Long> var10);

    public static OpenDatasetBuilder open() {
        return new OpenDatasetBuilder();
    }

    @Deprecated
    public static Dataset commit(BufferAllocator allocator, String path, FragmentOperation operation, Optional<Long> readVersion) {
        return Dataset.commit(allocator, path, operation, readVersion, new HashMap<String, String>());
    }

    @Deprecated
    public static Dataset commit(BufferAllocator allocator, String path, FragmentOperation operation, Optional<Long> readVersion, Map<String, String> storageOptions) {
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)operation);
        Preconditions.checkNotNull(readVersion);
        Dataset dataset = operation.commit(allocator, path, readVersion, storageOptions);
        dataset.allocator = allocator;
        return dataset;
    }

    @Deprecated
    public static native Dataset commitAppend(String var0, Optional<Long> var1, List<FragmentMetadata> var2, Map<String, String> var3);

    @Deprecated
    public static native Dataset commitOverwrite(String var0, long var1, Optional<Long> var3, List<FragmentMetadata> var4, Map<String, String> var5);

    public BufferAllocator allocator() {
        return this.allocator;
    }

    public Transaction.Builder newTransactionBuilder() {
        return new Transaction.Builder(this).readVersion(this.version());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset commitTransaction(Transaction transaction) {
        Preconditions.checkNotNull((Object)transaction);
        try {
            Dataset dataset = this.nativeCommitTransaction(transaction);
            dataset.allocator = this.selfManagedAllocator ? new RootAllocator(Long.MAX_VALUE) : this.allocator;
            Dataset dataset2 = dataset;
            return dataset2;
        }
        finally {
            transaction.release();
        }
    }

    private native Dataset nativeCommitTransaction(Transaction var1);

    public static native void drop(String var0, Map<String, String> var1);

    public void addColumns(SqlExpressions sqlExpressions, Optional<Long> batchSize) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeAddColumnsBySqlExpressions(sqlExpressions, batchSize);
        }
    }

    private native void nativeAddColumnsBySqlExpressions(SqlExpressions var1, Optional<Long> var2);

    public void addColumns(ArrowArrayStream stream, Optional<Long> batchSize) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeAddColumnsByReader(stream.memoryAddress(), batchSize);
        }
    }

    private native void nativeAddColumnsByReader(long var1, Optional<Long> var3);

    public void addColumns(Schema schema) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"Schema is empty");
            try (ArrowSchema arrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);){
                Data.exportSchema((BufferAllocator)this.allocator, (Schema)schema, null, (ArrowSchema)arrowSchema);
                this.nativeAddColumnsBySchema(arrowSchema.memoryAddress());
            }
        }
    }

    public void addColumns(List<Field> fields) {
        Preconditions.checkArgument((fields != null && !fields.isEmpty() ? 1 : 0) != 0, (Object)"Fields are empty");
        this.addColumns(new Schema(fields));
    }

    private native void nativeAddColumnsBySchema(long var1);

    public void dropColumns(List<String> columns) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeDropColumns(columns);
        }
    }

    private native void nativeDropColumns(List<String> var1);

    public void alterColumns(List<ColumnAlteration> columnAlterations) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeAlterColumns(columnAlterations);
        }
    }

    private native void nativeAlterColumns(List<ColumnAlteration> var1);

    public LanceScanner newScan() {
        return this.newScan(new ScanOptions.Builder().build());
    }

    public LanceScanner newScan(long batchSize) {
        return this.newScan(new ScanOptions.Builder().batchSize(batchSize).build());
    }

    public LanceScanner newScan(ScanOptions options) {
        Preconditions.checkNotNull((Object)options);
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            LanceScanner lanceScanner = LanceScanner.create(this, options, this.allocator);
            return lanceScanner;
        }
    }

    public ArrowReader take(List<Long> indices, List<String> columns) throws IOException {
        Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            byte[] arrowData = this.nativeTake(indices, columns);
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(arrowData);
            final ReadableByteChannel readChannel = Channels.newChannel(byteArrayInputStream);
            ArrowStreamReader arrowStreamReader = new ArrowStreamReader(readChannel, this.allocator){

                public void close() throws IOException {
                    super.close();
                    readChannel.close();
                    byteArrayInputStream.close();
                }
            };
            return arrowStreamReader;
        }
    }

    private native byte[] nativeTake(List<Long> var1, List<String> var2);

    public void delete(String predicate) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeDelete(predicate);
        }
    }

    private native void nativeDelete(String var1);

    public String uri() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            String string = this.nativeUri();
            return string;
        }
    }

    private native String nativeUri();

    public long version() {
        return this.getVersion().getId();
    }

    public Version getVersion() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Version version = this.nativeGetVersion();
            return version;
        }
    }

    private native Version nativeGetVersion();

    public List<Version> listVersions() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            List<Version> list = this.nativeListVersions();
            return list;
        }
    }

    private native List<Version> nativeListVersions();

    public long latestVersion() {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            long l = this.nativeGetLatestVersionId();
            return l;
        }
    }

    private native long nativeGetLatestVersionId();

    public void checkoutLatest() {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeCheckoutLatest();
        }
    }

    private native void nativeCheckoutLatest();

    public Dataset checkoutVersion(long version) {
        Preconditions.checkArgument((version > 0L ? 1 : 0) != 0, (Object)"version number must be greater than 0");
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Dataset dataset = this.nativeCheckoutVersion(version);
            return dataset;
        }
    }

    private native Dataset nativeCheckoutVersion(long var1);

    public Dataset checkoutTag(String tag) {
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"Tag can not be null");
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Dataset dataset = this.nativeCheckoutTag(tag);
            return dataset;
        }
    }

    private native Dataset nativeCheckoutTag(String var1);

    public void restore() {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeRestore();
        }
    }

    private native void nativeRestore();

    public void createIndex(List<String> columns, IndexType indexType, Optional<String> name, IndexParams params, boolean replace) {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeCreateIndex(columns, indexType.getValue(), name, params, replace);
        }
    }

    private native void nativeCreateIndex(List<String> var1, int var2, Optional<String> var3, IndexParams var4, boolean var5);

    public long countRows() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            long l = this.nativeCountRows(Optional.empty());
            return l;
        }
    }

    public long countRows(String filter) {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Preconditions.checkArgument((null != filter && !filter.isEmpty() ? 1 : 0) != 0, (Object)"filter cannot be null or empty");
            long l = this.nativeCountRows(Optional.of(filter));
            return l;
        }
    }

    private native long nativeCountRows(Optional<String> var1);

    public long calculateDataSize() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            long l = this.nativeGetDataStatistics().getDataSize();
            return l;
        }
    }

    private native DataStatistics nativeGetDataStatistics();

    public List<Fragment> getFragments() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            List<Fragment> list = this.getFragmentsNative().stream().map(metadata -> new Fragment(this, (FragmentMetadata)metadata)).collect(Collectors.toList());
            return list;
        }
    }

    private native List<FragmentMetadata> getFragmentsNative();

    /*
     * Exception decompiling
     */
    public Schema getSchema() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private native void importFfiSchema(long var1);

    public LanceSchema getLanceSchema() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            LanceSchema lanceSchema = this.nativeGetLanceSchema();
            return lanceSchema;
        }
    }

    private native LanceSchema nativeGetLanceSchema();

    public Optional<Transaction> readTransaction() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Optional<Transaction> optional = Optional.ofNullable(this.nativeReadTransaction());
            return optional;
        }
    }

    private native Transaction nativeReadTransaction();

    public List<String> listIndexes() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            List<String> list = this.nativeListIndexes();
            return list;
        }
    }

    private native List<String> nativeListIndexes();

    public Map<String, String> getConfig() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Map<String, String> map = this.nativeGetConfig();
            return map;
        }
    }

    private native Map<String, String> nativeGetConfig();

    public void compact(CompactionOptions options) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeCompact(options);
        }
    }

    public void compact() {
        this.compact(CompactionOptions.builder().build());
    }

    private native void nativeCompact(CompactionOptions var1);

    @Deprecated
    public void updateConfig(Map<String, String> tableConfig) {
        UpdateMap configUpdate = UpdateMap.builder().updates(tableConfig).replace(true).build();
        UpdateConfig operation = UpdateConfig.builder().configUpdates(configUpdate).build();
        Dataset newDataset = this.newTransactionBuilder().operation(operation).build().commit();
        this.updateToNewDataset(newDataset);
    }

    @Deprecated
    public void deleteConfigKeys(Set<String> deleteKeys) {
        HashMap<String, String> deleteMap = new HashMap<String, String>();
        deleteKeys.forEach(key -> {
            String cfr_ignored_0 = deleteMap.put((String)key, (String)null);
        });
        UpdateMap configUpdate = UpdateMap.builder().updates(deleteMap).replace(false).build();
        UpdateConfig operation = UpdateConfig.builder().configUpdates(configUpdate).build();
        Dataset newDataset = this.newTransactionBuilder().operation(operation).build().commit();
        this.updateToNewDataset(newDataset);
    }

    private void updateToNewDataset(Dataset newDataset) {
        this.close();
        this.nativeDatasetHandle = newDataset.nativeDatasetHandle;
        this.allocator = newDataset.allocator;
        this.selfManagedAllocator = newDataset.selfManagedAllocator;
        newDataset.nativeDatasetHandle = 0L;
    }

    @Override
    public void close() {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            if (this.nativeDatasetHandle != 0L) {
                this.releaseNativeDataset(this.nativeDatasetHandle);
                this.nativeDatasetHandle = 0L;
            }
            if (this.selfManagedAllocator) {
                this.allocator.close();
            }
        }
    }

    private native void releaseNativeDataset(long var1);

    private native List<BlobFile> nativeTakeBlobs(List<Long> var1, String var2);

    private native List<BlobFile> nativeTakeBlobsByIndices(List<Long> var1, String var2);

    public List<BlobFile> takeBlobs(List<Long> rowIds, String column) {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Preconditions.checkArgument((rowIds != null && !rowIds.isEmpty() ? 1 : 0) != 0, (Object)"rowIds cannot be null or empty");
            Preconditions.checkArgument((column != null && !column.isEmpty() ? 1 : 0) != 0, (Object)"column cannot be null or empty");
            List<BlobFile> list = this.nativeTakeBlobs(rowIds, column);
            return list;
        }
    }

    public List<BlobFile> takeBlobsByIndices(List<Long> rowIndices, String column) {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Preconditions.checkArgument((rowIndices != null && !rowIndices.isEmpty() ? 1 : 0) != 0, (Object)"rowIndices cannot be null or empty");
            Preconditions.checkArgument((column != null && !column.isEmpty() ? 1 : 0) != 0, (Object)"column cannot be null or empty");
            List<BlobFile> list = this.nativeTakeBlobsByIndices(rowIndices, column);
            return list;
        }
    }

    public boolean closed() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            boolean bl = this.nativeDatasetHandle == 0L;
            return bl;
        }
    }

    public Fragment getFragment(int fragmentId) {
        FragmentMetadata metadata = this.getFragmentNative(fragmentId);
        return new Fragment(this, metadata);
    }

    private native FragmentMetadata getFragmentNative(int var1);

    public Tags tags() {
        return new Tags();
    }

    public Branches branches() {
        return new Branches();
    }

    public Dataset checkout(Ref ref) {
        Preconditions.checkNotNull((Object)ref);
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Dataset dataset = this.nativeCheckout(ref);
            return dataset;
        }
    }

    public Map<String, String> getTableMetadata() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Map<String, String> map = this.nativeGetTableMetadata();
            return map;
        }
    }

    private native Map<String, String> nativeGetTableMetadata();

    public SqlQuery sql(String sql) {
        return new SqlQuery(this, sql);
    }

    public MergeInsertResult mergeInsert(MergeInsertParams mergeInsert, ArrowArrayStream source) {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            MergeInsertResult result = this.nativeMergeInsert(mergeInsert, source.memoryAddress());
            Dataset newDataset = result.dataset();
            newDataset.allocator = this.selfManagedAllocator ? new RootAllocator(Long.MAX_VALUE) : this.allocator;
            MergeInsertResult mergeInsertResult = result;
            return mergeInsertResult;
        }
    }

    private native MergeInsertResult nativeMergeInsert(MergeInsertParams var1, long var2);

    private native void nativeCreateTag(String var1, long var2);

    private native void nativeCreateTagOnBranch(String var1, long var2, String var4);

    private native void nativeDeleteTag(String var1);

    private native void nativeUpdateTag(String var1, long var2);

    private native void nativeUpdateTagOnBranch(String var1, long var2, String var4);

    private native List<Tag> nativeListTags();

    private native long nativeGetVersionByTag(String var1);

    private native Dataset nativeCheckout(Ref var1);

    private native Dataset nativeCreateBranch(String var1, long var2, Optional<String> var4);

    private native Dataset nativeCreateBranchOnTag(String var1, String var2);

    private native void nativeDeleteBranch(String var1);

    private native List<Branch> nativeListBranches();

    public Dataset shallowClone(String targetPath, Ref ref) {
        return this.shallowClone(targetPath, ref, null);
    }

    public Dataset shallowClone(String targetPath, Ref ref, Map<String, String> storageOptions) {
        Preconditions.checkArgument((targetPath != null ? 1 : 0) != 0, (Object)"Target path can not be null");
        Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (Object)"globalVersion can not be null");
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Dataset newDataset = this.nativeShallowClone(targetPath, ref, Optional.ofNullable(storageOptions));
            newDataset.allocator = this.selfManagedAllocator ? new RootAllocator(Long.MAX_VALUE) : this.allocator;
            Dataset dataset = newDataset;
            return dataset;
        }
    }

    private native Dataset nativeShallowClone(String var1, Ref var2, Optional<Map<String, String>> var3);

    static {
        JniLoader.ensureLoaded();
    }

    public class Branches {
        public Dataset create(String branch, long versionNumber) {
            try (LockManager.WriteLock writeLock = Dataset.this.lockManager.acquireWriteLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                Dataset dataset = Dataset.this.nativeCreateBranch(branch, versionNumber, Optional.empty());
                return dataset;
            }
        }

        public Dataset create(String branchName, long versionNumber, String sourceBranch) {
            try (LockManager.WriteLock writeLock = Dataset.this.lockManager.acquireWriteLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                Preconditions.checkNotNull((Object)sourceBranch);
                Dataset dataset = Dataset.this.nativeCreateBranch(branchName, versionNumber, Optional.of(sourceBranch));
                return dataset;
            }
        }

        public Dataset create(String branchName, String sourceTag) {
            try (LockManager.WriteLock writeLock = Dataset.this.lockManager.acquireWriteLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                Preconditions.checkNotNull((Object)sourceTag);
                Dataset dataset = Dataset.this.nativeCreateBranchOnTag(branchName, sourceTag);
                return dataset;
            }
        }

        public void delete(String branchName) {
            try (LockManager.WriteLock writeLock = Dataset.this.lockManager.acquireWriteLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                Dataset.this.nativeDeleteBranch(branchName);
            }
        }

        public List<Branch> list() {
            try (LockManager.ReadLock readLock = Dataset.this.lockManager.acquireReadLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                List list = Dataset.this.nativeListBranches();
                return list;
            }
        }
    }

    public class Tags {
        public void create(String tag, long versionNumber) {
            try (LockManager.WriteLock writeLock = Dataset.this.lockManager.acquireWriteLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                Dataset.this.nativeCreateTag(tag, versionNumber);
            }
        }

        public void create(String tag, long versionNumber, String targetBranch) {
            Preconditions.checkArgument((targetBranch != null ? 1 : 0) != 0, (Object)"Branch cannot be null");
            try (LockManager.WriteLock writeLock = Dataset.this.lockManager.acquireWriteLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                Dataset.this.nativeCreateTagOnBranch(tag, versionNumber, targetBranch);
            }
        }

        public void delete(String tag) {
            try (LockManager.WriteLock writeLock = Dataset.this.lockManager.acquireWriteLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                Dataset.this.nativeDeleteTag(tag);
            }
        }

        public void update(String tag, long versionNumber) {
            try (LockManager.WriteLock writeLock = Dataset.this.lockManager.acquireWriteLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                Dataset.this.nativeUpdateTag(tag, versionNumber);
            }
        }

        public void update(String tag, long version, String targetBranch) {
            Preconditions.checkArgument((targetBranch != null ? 1 : 0) != 0, (Object)"Branch cannot be null");
            try (LockManager.WriteLock writeLock = Dataset.this.lockManager.acquireWriteLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                Dataset.this.nativeUpdateTagOnBranch(tag, version, targetBranch);
            }
        }

        public List<Tag> list() {
            try (LockManager.ReadLock readLock = Dataset.this.lockManager.acquireReadLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                List list = Dataset.this.nativeListTags();
                return list;
            }
        }

        public long getVersion(String tag) {
            try (LockManager.ReadLock readLock = Dataset.this.lockManager.acquireReadLock();){
                Preconditions.checkArgument((Dataset.this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
                long l = Dataset.this.nativeGetVersionByTag(tag);
                return l;
            }
        }
    }
}

