/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index.scalar;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.Optional;

public class ScalarIndexParams {
    private final String indexType;
    private final Optional<String> jsonParams;

    private ScalarIndexParams(Builder builder) {
        this.indexType = builder.indexType;
        this.jsonParams = builder.jsonParams;
    }

    public static ScalarIndexParams create(String indexType) {
        return new Builder(indexType).build();
    }

    public static ScalarIndexParams create(String indexType, String jsonParams) {
        return new Builder(indexType).setJsonParams(jsonParams).build();
    }

    public String getIndexType() {
        return this.indexType;
    }

    public Optional<String> getJsonParams() {
        return this.jsonParams;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("indexType", this.indexType).add("jsonParams", this.jsonParams.orElse(null)).toString();
    }

    public static class Builder {
        private final String indexType;
        private Optional<String> jsonParams = Optional.empty();

        public Builder(String indexType) {
            this.indexType = indexType;
        }

        public Builder setJsonParams(String jsonParams) {
            this.jsonParams = Optional.of(jsonParams);
            return this;
        }

        public ScalarIndexParams build() {
            return new ScalarIndexParams(this);
        }
    }
}

