/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.lancedb.lance.io.StorageOptionsProvider;
import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import java.util.List;
import java.util.Map;

public class LanceNamespaceStorageOptionsProvider
implements StorageOptionsProvider {
    private final LanceNamespace namespace;
    private final List<String> tableId;

    public LanceNamespaceStorageOptionsProvider(LanceNamespace namespace, List<String> tableId) {
        this.namespace = namespace;
        this.tableId = tableId;
    }

    @Override
    public Map<String, String> fetchStorageOptions() {
        DescribeTableRequest request = new DescribeTableRequest();
        request.setId(this.tableId);
        DescribeTableResponse response = this.namespace.describeTable(request);
        Map storageOptions = response.getStorageOptions();
        if (storageOptions == null || storageOptions.isEmpty()) {
            throw new RuntimeException("Namespace did not return storage_options. Ensure the namespace supports credential vending.");
        }
        if (!storageOptions.containsKey("expires_at_millis")) {
            throw new RuntimeException("Namespace storage_options missing 'expires_at_millis'. Credential refresh will not work properly.");
        }
        return storageOptions;
    }

    @Override
    public String providerId() {
        String namespaceId = this.namespace.namespaceId();
        return String.format("LanceNamespaceStorageOptionsProvider { namespace: %s, table_id: %s }", namespaceId, this.tableId);
    }
}

