/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.operation.Operation;
import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Update
implements Operation {
    private final List<Long> removedFragmentIds;
    private final List<FragmentMetadata> updatedFragments;
    private final List<FragmentMetadata> newFragments;
    private final long[] fieldsModified;
    private final long[] fieldsForPreservingFragBitmap;
    private final Optional<UpdateMode> updateMode;

    private Update(List<Long> removedFragmentIds, List<FragmentMetadata> updatedFragments, List<FragmentMetadata> newFragments, long[] fieldsModified, long[] fieldsForPreservingFragBitmap, Optional<UpdateMode> updateMode) {
        this.removedFragmentIds = removedFragmentIds;
        this.updatedFragments = updatedFragments;
        this.newFragments = newFragments;
        this.fieldsModified = fieldsModified;
        this.fieldsForPreservingFragBitmap = fieldsForPreservingFragBitmap;
        this.updateMode = updateMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Long> removedFragmentIds() {
        return this.removedFragmentIds;
    }

    public List<FragmentMetadata> updatedFragments() {
        return this.updatedFragments;
    }

    public List<FragmentMetadata> newFragments() {
        return this.newFragments;
    }

    public long[] fieldsModified() {
        return this.fieldsModified;
    }

    public long[] fieldsForPreservingFragBitmap() {
        return this.fieldsForPreservingFragBitmap;
    }

    public Optional<UpdateMode> updateMode() {
        return this.updateMode;
    }

    @Override
    public String name() {
        return "Update";
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("removedFragmentIds", this.removedFragmentIds).add("updatedFragments", this.updatedFragments).add("newFragments", this.newFragments).add("fieldsModified", this.fieldsModified).add("fieldsForPreservingFragBitmap", this.fieldsForPreservingFragBitmap).add("updateMode", this.updateMode).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Update that = (Update)o;
        return Objects.equals(this.removedFragmentIds, that.removedFragmentIds) && Objects.equals(this.updatedFragments, that.updatedFragments) && Objects.equals(this.newFragments, that.newFragments) && Arrays.equals(this.fieldsModified, that.fieldsModified) && Arrays.equals(this.fieldsForPreservingFragBitmap, that.fieldsForPreservingFragBitmap) && Objects.equals(this.updateMode, that.updateMode);
    }

    public static class Builder {
        private List<Long> removedFragmentIds = Collections.emptyList();
        private List<FragmentMetadata> updatedFragments = Collections.emptyList();
        private List<FragmentMetadata> newFragments = Collections.emptyList();
        private long[] fieldsModified = new long[0];
        private long[] fieldsForPreservingFragBitmap = new long[0];
        private Optional<UpdateMode> updateMode = Optional.empty();

        private Builder() {
        }

        public Builder removedFragmentIds(List<Long> removedFragmentIds) {
            this.removedFragmentIds = removedFragmentIds;
            return this;
        }

        public Builder updatedFragments(List<FragmentMetadata> updatedFragments) {
            this.updatedFragments = updatedFragments;
            return this;
        }

        public Builder newFragments(List<FragmentMetadata> newFragments) {
            this.newFragments = newFragments;
            return this;
        }

        public Builder fieldsModified(long[] fieldsModified) {
            this.fieldsModified = fieldsModified;
            return this;
        }

        public Builder fieldsForPreservingFragBitmap(long[] fieldsForPreservingFragBitmap) {
            this.fieldsForPreservingFragBitmap = fieldsForPreservingFragBitmap;
            return this;
        }

        public Builder updateMode(Optional<UpdateMode> updateMode) {
            this.updateMode = updateMode;
            return this;
        }

        public Update build() {
            return new Update(this.removedFragmentIds, this.updatedFragments, this.newFragments, this.fieldsModified, this.fieldsForPreservingFragBitmap, this.updateMode);
        }
    }

    public static enum UpdateMode {
        RewriteRows,
        RewriteColumns;

    }
}

