/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.shaded.guava.collect;

import com.lancedb.lance.shaded.guava.annotations.GwtCompatible;
import com.lancedb.lance.shaded.guava.annotations.GwtIncompatible;
import com.lancedb.lance.shaded.guava.annotations.J2ktIncompatible;
import com.lancedb.lance.shaded.guava.collect.AbstractMapBasedMultiset;
import com.lancedb.lance.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import com.lancedb.lance.shaded.guava.collect.Iterables;
import com.lancedb.lance.shaded.guava.collect.Maps;
import com.lancedb.lance.shaded.guava.collect.Multisets;
import com.lancedb.lance.shaded.guava.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> LinkedHashMultiset<E> create() {
        return new LinkedHashMultiset<E>();
    }

    public static <E> LinkedHashMultiset<E> create(int distinctElements) {
        return new LinkedHashMultiset<E>(distinctElements);
    }

    public static <E> LinkedHashMultiset<E> create(Iterable<? extends E> elements) {
        LinkedHashMultiset<E> multiset = LinkedHashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private LinkedHashMultiset() {
        super(new LinkedHashMap());
    }

    private LinkedHashMultiset(int distinctElements) {
        super(Maps.newLinkedHashMapWithExpectedSize(distinctElements));
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int distinctElements = Serialization.readCount(stream);
        this.setBackingMap(new LinkedHashMap());
        Serialization.populateMultiset(this, stream, distinctElements);
    }
}

