/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.shaded.guava.graph;

import com.lancedb.lance.shaded.guava.collect.BiMap;
import com.lancedb.lance.shaded.guava.collect.HashBiMap;
import com.lancedb.lance.shaded.guava.collect.ImmutableBiMap;
import com.lancedb.lance.shaded.guava.graph.AbstractUndirectedNetworkConnections;
import com.lancedb.lance.shaded.guava.graph.EdgesConnecting;
import com.lancedb.lance.shaded.guava.graph.ElementTypesAreNonnullByDefault;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
final class UndirectedNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    UndirectedNetworkConnections(Map<E, N> incidentEdgeMap) {
        super(incidentEdgeMap);
    }

    static <N, E> UndirectedNetworkConnections<N, E> of() {
        return new UndirectedNetworkConnections(HashBiMap.create(2));
    }

    static <N, E> UndirectedNetworkConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(incidentEdges));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(((BiMap)this.incidentEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.incidentEdgeMap).inverse(), node);
    }
}

