/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.io.IOException;
import org.apache.paimon.format.parquet.ParquetInputStream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.org.apache.parquet.io.InputFile;

public class ParquetInputFile
implements InputFile {
    private final FileIO fileIO;
    private final Path path;
    private final long length;

    public static ParquetInputFile fromPath(FileIO fileIO, Path path, long length) throws IOException {
        return new ParquetInputFile(fileIO, path, length);
    }

    private ParquetInputFile(FileIO fileIO, Path path, long length) {
        this.fileIO = fileIO;
        this.path = path;
        this.length = length;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public ParquetInputStream newStream() throws IOException {
        return new ParquetInputStream(this.fileIO.newInputStream(this.path));
    }

    public String toString() {
        return this.path.toString();
    }
}

