/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.util.Arrays;
import org.apache.paimon.data.columnar.ArrayColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarRow;
import org.apache.paimon.data.columnar.ColumnarRowIterator;
import org.apache.paimon.data.columnar.MapColumnVector;
import org.apache.paimon.data.columnar.RowColumnVector;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.data.columnar.VectorizedRowIterator;
import org.apache.paimon.fs.Path;
import org.apache.paimon.utils.LongIterator;

public class ColumnarBatch {
    protected final ColumnVector[] columns;
    protected final VectorizedColumnBatch vectorizedColumnBatch;
    protected final ColumnarRowIterator vectorizedRowIterator;

    public ColumnarBatch(Path filePath, ColumnVector[] columns) {
        this.columns = columns;
        this.vectorizedColumnBatch = new VectorizedColumnBatch(columns);
        boolean containsNestedColumn = Arrays.stream(columns).anyMatch(vector -> vector instanceof MapColumnVector || vector instanceof RowColumnVector || vector instanceof ArrayColumnVector);
        ColumnarRow row = new ColumnarRow(this.vectorizedColumnBatch);
        this.vectorizedRowIterator = containsNestedColumn ? new ColumnarRowIterator(filePath, row, null) : new VectorizedRowIterator(filePath, row, null);
    }

    public void resetPositions(LongIterator positions) {
        this.vectorizedRowIterator.reset(positions);
    }

    public void setNumRows(int numRows) {
        this.vectorizedColumnBatch.setNumRows(numRows);
    }

    public ColumnVector column(int ordinal) {
        return this.columns[ordinal];
    }
}

