/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.exceptions.ForbiddenException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationRequest;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionEvaluator;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.filter.ParameterUtil;
import org.apache.gravitino.server.web.filter.authorization.AuthorizationExecutor;
import org.apache.gravitino.server.web.filter.authorization.AuthorizeExecutorFactory;
import org.apache.gravitino.server.web.rest.CatalogOperations;
import org.apache.gravitino.server.web.rest.FilesetOperations;
import org.apache.gravitino.server.web.rest.GroupOperations;
import org.apache.gravitino.server.web.rest.JobOperations;
import org.apache.gravitino.server.web.rest.MetadataObjectCredentialOperations;
import org.apache.gravitino.server.web.rest.MetadataObjectPolicyOperations;
import org.apache.gravitino.server.web.rest.MetadataObjectTagOperations;
import org.apache.gravitino.server.web.rest.MetalakeOperations;
import org.apache.gravitino.server.web.rest.ModelOperations;
import org.apache.gravitino.server.web.rest.OwnerOperations;
import org.apache.gravitino.server.web.rest.PartitionOperations;
import org.apache.gravitino.server.web.rest.PermissionOperations;
import org.apache.gravitino.server.web.rest.PolicyOperations;
import org.apache.gravitino.server.web.rest.RoleOperations;
import org.apache.gravitino.server.web.rest.SchemaOperations;
import org.apache.gravitino.server.web.rest.StatisticOperations;
import org.apache.gravitino.server.web.rest.TableOperations;
import org.apache.gravitino.server.web.rest.TagOperations;
import org.apache.gravitino.server.web.rest.TopicOperations;
import org.apache.gravitino.server.web.rest.UserOperations;
import org.apache.gravitino.utils.PrincipalUtils;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.InterceptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravitinoInterceptionService
implements InterceptionService {
    public Filter getDescriptorFilter() {
        return new ClassListFilter((Set<String>)ImmutableSet.of((Object)MetalakeOperations.class.getName(), (Object)CatalogOperations.class.getName(), (Object)SchemaOperations.class.getName(), (Object)TableOperations.class.getName(), (Object)ModelOperations.class.getName(), (Object)TopicOperations.class.getName(), (Object[])new String[]{FilesetOperations.class.getName(), UserOperations.class.getName(), GroupOperations.class.getName(), PermissionOperations.class.getName(), RoleOperations.class.getName(), OwnerOperations.class.getName(), StatisticOperations.class.getName(), PartitionOperations.class.getName(), MetadataObjectTagOperations.class.getName(), TagOperations.class.getName(), PolicyOperations.class.getName(), MetadataObjectPolicyOperations.class.getName(), JobOperations.class.getName(), MetadataObjectCredentialOperations.class.getName()}));
    }

    public List<MethodInterceptor> getMethodInterceptors(Method method) {
        return ImmutableList.of((Object)new MetadataAuthorizationMethodInterceptor());
    }

    public List<ConstructorInterceptor> getConstructorInterceptors(Constructor<?> constructor) {
        return Collections.emptyList();
    }

    private record ClassListFilter(Set<String> targetClasses) implements Filter
    {
        private ClassListFilter(Set<String> targetClasses) {
            this.targetClasses = new HashSet<String>(targetClasses);
        }

        public boolean matches(Descriptor descriptor) {
            String implementation = descriptor.getImplementation();
            return this.targetClasses.contains(implementation);
        }
    }

    private static class MetadataAuthorizationMethodInterceptor
    implements MethodInterceptor {
        private static final Logger LOG = LoggerFactory.getLogger(MetadataAuthorizationMethodInterceptor.class);

        private MetadataAuthorizationMethodInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            Method method = methodInvocation.getMethod();
            Parameter[] parameters = method.getParameters();
            AuthorizationExpression expressionAnnotation = method.getAnnotation(AuthorizationExpression.class);
            try {
                if (expressionAnnotation != null) {
                    String expression = expressionAnnotation.expression();
                    Object[] args = methodInvocation.getArguments();
                    String entityType = ParameterUtil.extractMetadataObjectTypeFromParameters(parameters, args);
                    Map<Entity.EntityType, NameIdentifier> metadataContext = ParameterUtil.extractNameIdentifierFromParameters(parameters, args);
                    Map pathParams = Utils.extractPathParamsFromParameters((Parameter[])parameters, (Object[])args);
                    NameIdentifier metalakeIdent = metadataContext.get(Entity.EntityType.METALAKE);
                    if (metalakeIdent != null) {
                        String currentUser = PrincipalUtils.getCurrentUserName();
                        try {
                            AuthorizationUtils.checkCurrentUser((String)metalakeIdent.name(), (String)currentUser);
                        }
                        catch (NoSuchMetalakeException e) {
                            LOG.warn("Metalake {} does not exist when validating user {}", (Object)metalakeIdent, (Object)currentUser);
                            return this.buildNoAuthResponse(expressionAnnotation, metadataContext, method, expression);
                        }
                        catch (ForbiddenException ex) {
                            LOG.warn("User validation failed - User: {}, Metalake: {}, Reason: {}", new Object[]{currentUser, metalakeIdent.name(), ex.getMessage()});
                            return Utils.forbidden((String)ex.getMessage(), (Throwable)ex);
                        }
                        catch (Exception ex) {
                            LOG.error("Unexpected error during user validation - User: {}, Metalake: {}", new Object[]{currentUser, metalakeIdent.name(), ex});
                            return Utils.internalError((String)"Failed to validate user", (Throwable)ex);
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)expression)) {
                        AuthorizationExpressionEvaluator authorizationExpressionEvaluator = new AuthorizationExpressionEvaluator(expression);
                        AuthorizationRequest.RequestType requestType = ParameterUtil.extractAuthorizationRequestTypeFromParameters(parameters);
                        AuthorizationExecutor executor = AuthorizeExecutorFactory.create(expression, requestType, metadataContext, authorizationExpressionEvaluator, pathParams, entityType, parameters, args);
                        boolean authorizeResult = executor.execute();
                        if (!authorizeResult) {
                            return this.buildNoAuthResponse(expressionAnnotation, metadataContext, method, expression);
                        }
                    }
                }
                return methodInvocation.proceed();
            }
            catch (Exception ex) {
                String currentUser = PrincipalUtils.getCurrentUserName();
                String methodName = methodInvocation.getMethod().getName();
                LOG.error("System internal error during authorization - User: {}, Operation: {}", new Object[]{currentUser, methodName, ex});
                return Utils.internalError((String)"Authorization failed due to system internal error. Please contact administrator.", (Throwable)ex);
            }
        }

        private Response buildNoAuthResponse(AuthorizationExpression expressionAnnotation, Map<Entity.EntityType, NameIdentifier> metadataContext, Method method, String expression) {
            MetadataObject.Type type = expressionAnnotation.accessMetadataType();
            NameIdentifier accessMetadataName = metadataContext.get(Entity.EntityType.valueOf((String)type.name()));
            String errorMessage = expressionAnnotation.errorMessage();
            String currentUser = PrincipalUtils.getCurrentUserName();
            String methodName = method.getName();
            LOG.warn("Authorization failed - User: {}, Operation: {}, Metadata: {}, Expression: {}", new Object[]{currentUser, methodName, accessMetadataName, expression});
            return this.buildNoAuthResponse(errorMessage, accessMetadataName, currentUser, methodName);
        }

        private Response buildNoAuthResponse(String errorMessage, NameIdentifier accessMetadataName, String currentUser, String methodName) {
            String accessMetadataMessage = accessMetadataName != null ? String.format("on metadata '%s'", accessMetadataName.name()) : "";
            String contextualMessage = StringUtils.isNotBlank((CharSequence)errorMessage) ? String.format("User '%s' is not authorized to perform operation '%s' %s: %s", currentUser, methodName, accessMetadataMessage, errorMessage) : String.format("User '%s' is not authorized to perform operation '%s' %s", currentUser, methodName, accessMetadataMessage);
            return Utils.forbidden((String)contextualMessage, null);
        }
    }
}

