/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter.authorization;

import com.google.common.base.Preconditions;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.dto.requests.PoliciesAssociateRequest;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionEvaluator;
import org.apache.gravitino.server.web.filter.ParameterUtil;
import org.apache.gravitino.server.web.filter.authorization.AuthorizationExecutor;
import org.apache.gravitino.server.web.filter.authorization.CommonAuthorizerExecutor;

public class AssociatePolicyAuthorizationExecutor
extends CommonAuthorizerExecutor
implements AuthorizationExecutor {
    private final Parameter[] parameters;
    private final Object[] args;

    public AssociatePolicyAuthorizationExecutor(String expression, Parameter[] parameters, Object[] args, Map<Entity.EntityType, NameIdentifier> metadataContext, AuthorizationExpressionEvaluator authorizationExpressionEvaluator, Map<String, Object> pathParams, String entityType) {
        super(expression, metadataContext, authorizationExpressionEvaluator, pathParams, entityType);
        this.parameters = parameters;
        this.args = args;
    }

    @Override
    public boolean execute() throws Exception {
        Object request = ParameterUtil.extractFromParameters(this.parameters, this.args);
        if (request == null) {
            return false;
        }
        AuthorizationRequestContext context = new AuthorizationRequestContext();
        context.setOriginalAuthorizationExpression(this.expression);
        Entity.EntityType targetType = Entity.EntityType.POLICY;
        Preconditions.checkArgument((boolean)(request instanceof PoliciesAssociateRequest), (Object)"Only policy can use AssociatePolicyAuthorizationExecutor, please contact the administrator.");
        PoliciesAssociateRequest policiesAssociateRequest = (PoliciesAssociateRequest)request;
        policiesAssociateRequest.validate();
        return this.authorizePolicy(policiesAssociateRequest.getPoliciesToAdd(), context, targetType) && this.authorizePolicy(policiesAssociateRequest.getPoliciesToRemove(), context, targetType);
    }

    private boolean authorizePolicy(String[] policies, AuthorizationRequestContext context, Entity.EntityType targetType) {
        if (policies == null) {
            return true;
        }
        for (String policy : policies) {
            HashMap<Entity.EntityType, NameIdentifier> currentContext = new HashMap<Entity.EntityType, NameIdentifier>(this.metadataContext);
            ParameterUtil.buildNameIdentifierForBatchAuthorization(currentContext, policy, targetType);
            boolean authorized = this.authorizationExpressionEvaluator.evaluate(currentContext, this.pathParams, context, Optional.ofNullable(this.entityType));
            if (authorized) continue;
            return false;
        }
        return true;
    }
}

