/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.dto.policy.PolicyDTO;
import org.apache.gravitino.dto.requests.PoliciesAssociateRequest;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.PolicyListResponse;
import org.apache.gravitino.dto.responses.PolicyResponse;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.meta.PolicyEntity;
import org.apache.gravitino.policy.PolicyDispatcher;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationFullName;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.annotations.AuthorizationObjectType;
import org.apache.gravitino.server.authorization.annotations.AuthorizationRequest;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.server.web.rest.PolicyOperations;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes/{metalake}/objects/{type}/{fullName}/policies")
public class MetadataObjectPolicyOperations {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataObjectPolicyOperations.class);
    private final PolicyDispatcher policyDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public MetadataObjectPolicyOperations(PolicyDispatcher policyDispatcher) {
        this.policyDispatcher = policyDispatcher;
    }

    @GET
    @Path(value="{policy}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-object-policy.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-object-policy", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || ((POLICY::OWNER || ANY_APPLY_POLICY) && (CAN_ACCESS_METADATA))")
    public Response getPolicyForObject(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, @PathParam(value="policy") @AuthorizationMetadata(type=Entity.EntityType.POLICY) String policyName) {
        LOG.info("Received get policy {} request for object type: {}, full name: {} under metalake: {}", new Object[]{policyName, type, fullName, metalake});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                Optional<PolicyEntity> policyEntity = this.getPolicyForObject(metalake, object, policyName);
                Optional<PolicyDTO> policyDTO = policyEntity.map(t -> PolicyOperations.toDTO(t, Optional.of(false)));
                MetadataObject parentObject = MetadataObjects.parent((MetadataObject)object);
                while (!policyEntity.isPresent() && parentObject != null) {
                    policyEntity = this.getPolicyForObject(metalake, parentObject, policyName);
                    policyDTO = policyEntity.map(t -> PolicyOperations.toDTO(t, Optional.of(true)));
                    parentObject = MetadataObjects.parent((MetadataObject)parentObject);
                }
                if (!policyDTO.isPresent()) {
                    LOG.warn("Policy {} not found for object type: {}, full name: {} under metalake: {}", new Object[]{policyName, type, fullName, metalake});
                    return Utils.notFound((String)NoSuchPolicyException.class.getSimpleName(), (String)("Policy not found: " + policyName + " for object type: " + type + ", full name: " + fullName + " under metalake: " + metalake));
                }
                LOG.info("Get policy: {} for object type: {}, full name: {} under metalake: {}", new Object[]{policyName, type, fullName, metalake});
                return Utils.ok((Object)new PolicyResponse(policyDTO.get()));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(OperationType.GET, policyName, fullName, e);
        }
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-object-policies.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-object-policies", absolute=true)
    @AuthorizationExpression(expression="CAN_ACCESS_METADATA")
    public Response listPoliciesForMetadataObject(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        LOG.info("Received list policy {} request for object type: {}, full name: {} under metalake: {}", new Object[]{verbose ? "infos" : "names", type, fullName, metalake});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                HashSet policies = Sets.newHashSet();
                Object[] nonInheritedPolicies = this.policyDispatcher.listPolicyInfosForMetadataObject(metalake, object);
                if (ArrayUtils.isNotEmpty((Object[])(nonInheritedPolicies = (PolicyEntity[])MetadataAuthzHelper.filterByExpression((String)metalake, (String)"METALAKE::OWNER || POLICY::OWNER || ANY_APPLY_POLICY\n", (Entity.EntityType)Entity.EntityType.POLICY, (Object[])nonInheritedPolicies, policyEntity -> NameIdentifierUtil.ofPolicy((String)metalake, (String)policyEntity.name()))))) {
                    Collections.addAll(policies, (PolicyDTO[])Arrays.stream(nonInheritedPolicies).map(t -> PolicyOperations.toDTO(t, Optional.of(false))).toArray(PolicyDTO[]::new));
                }
                MetadataObject parentObject = MetadataObjects.parent((MetadataObject)object);
                while (parentObject != null) {
                    Object[] inheritedPolicies = this.policyDispatcher.listPolicyInfosForMetadataObject(metalake, parentObject);
                    if (ArrayUtils.isNotEmpty((Object[])inheritedPolicies)) {
                        Collections.addAll(policies, (PolicyDTO[])Arrays.stream(inheritedPolicies).map(t -> PolicyOperations.toDTO(t, Optional.of(true))).toArray(PolicyDTO[]::new));
                    }
                    parentObject = MetadataObjects.parent((MetadataObject)parentObject);
                }
                if (verbose) {
                    LOG.info("List {} policies info for object type: {}, full name: {} under metalake: {}", new Object[]{policies.size(), type, fullName, metalake});
                    return Utils.ok((Object)new PolicyListResponse(policies.toArray(new PolicyDTO[0])));
                }
                String[] policyNames = (String[])policies.stream().map(PolicyDTO::name).toArray(String[]::new);
                LOG.info("List {} policies for object type: {}, full name: {} under metalake: {}", new Object[]{policyNames.length, type, fullName, metalake});
                return Utils.ok((Object)new NameListResponse(policyNames));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(OperationType.LIST, "", fullName, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="associate-object-policies.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="associate-object-policies", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || ((POLICY::OWNER || ANY_APPLY_POLICY) && (CAN_ACCESS_METADATA))")
    public Response associatePoliciesForObject(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, @AuthorizationRequest(type=AuthorizationRequest.RequestType.ASSOCIATE_POLICY) PoliciesAssociateRequest request) {
        LOG.info("Received associate policies request for object type: {}, full name: {} under metalake: {}", new Object[]{type, fullName, metalake});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                Object[] policyNames = this.policyDispatcher.associatePoliciesForMetadataObject(metalake, object, request.getPoliciesToAdd(), request.getPoliciesToRemove());
                policyNames = policyNames == null ? new String[]{} : policyNames;
                LOG.info("Associated policies: {} for object type: {}, full name: {} under metalake: {}", new Object[]{Arrays.toString(policyNames), type, fullName, metalake});
                return Utils.ok((Object)new NameListResponse((String[])policyNames));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(OperationType.ASSOCIATE, "", fullName, e);
        }
    }

    private Optional<PolicyEntity> getPolicyForObject(String metalake, MetadataObject object, String policyName) {
        try {
            return Optional.ofNullable(this.policyDispatcher.getPolicyForMetadataObject(metalake, object, policyName));
        }
        catch (NoSuchPolicyException e) {
            LOG.info("Policy {} not found for object: {}", (Object)policyName, (Object)object);
            return Optional.empty();
        }
    }
}

