/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.jni;

import org.apache.arrow.dataset.jni.JniWrapper;
import org.apache.arrow.dataset.jni.NativeContext;
import org.apache.arrow.dataset.jni.NativeInstanceReleasedException;
import org.apache.arrow.dataset.jni.NativeScanner;
import org.apache.arrow.dataset.scanner.ScanOptions;
import org.apache.arrow.dataset.source.Dataset;

public class NativeDataset
implements Dataset {
    private final NativeContext context;
    private final long datasetId;
    private boolean closed = false;

    public NativeDataset(NativeContext context, long datasetId) {
        this.context = context;
        this.datasetId = datasetId;
    }

    @Override
    public synchronized NativeScanner newScan(ScanOptions options) {
        if (this.closed) {
            throw new NativeInstanceReleasedException();
        }
        long scannerId = JniWrapper.get().createScanner(this.datasetId, options.getColumns().orElse(null), options.getSubstraitProjection().orElse(null), options.getSubstraitFilter().orElse(null), options.getBatchSize(), this.context.getMemoryPool().getNativeInstanceId());
        return new NativeScanner(this.context, scannerId);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        JniWrapper.get().closeDataset(this.datasetId);
    }
}

