/*
 * Decompiled with CFR 0.152.
 */
package ognl.internal.entry;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import ognl.internal.CacheException;
import ognl.internal.entry.CacheEntryFactory;
import ognl.internal.entry.GenericMethodParameterTypeCacheEntry;

public class GenericMethodParameterTypeFactory
implements CacheEntryFactory<GenericMethodParameterTypeCacheEntry, Class<?>[]> {
    @Override
    public Class<?>[] create(GenericMethodParameterTypeCacheEntry entry) throws CacheException {
        ParameterizedType param = (ParameterizedType)entry.type.getGenericSuperclass();
        Type[] genTypes = entry.method.getGenericParameterTypes();
        TypeVariable<Class<?>>[] declaredTypes = entry.method.getDeclaringClass().getTypeParameters();
        Class[] types = new Class[genTypes.length];
        for (int i = 0; i < genTypes.length; ++i) {
            TypeVariable paramType = null;
            if (genTypes[i] instanceof TypeVariable) {
                paramType = (TypeVariable)genTypes[i];
            } else if (genTypes[i] instanceof GenericArrayType) {
                paramType = (TypeVariable)((GenericArrayType)genTypes[i]).getGenericComponentType();
            } else {
                if (genTypes[i] instanceof ParameterizedType) {
                    types[i] = (Class)((ParameterizedType)genTypes[i]).getRawType();
                    continue;
                }
                if (genTypes[i] instanceof Class) {
                    types[i] = (Class)genTypes[i];
                    continue;
                }
            }
            Class<?> resolved = this.resolveType(param, paramType, declaredTypes);
            if (resolved != null) {
                if (genTypes[i] instanceof GenericArrayType) {
                    resolved = Array.newInstance(resolved, 0).getClass();
                }
                types[i] = resolved;
                continue;
            }
            types[i] = entry.method.getParameterTypes()[i];
        }
        return types;
    }

    private Class<?> resolveType(ParameterizedType param, TypeVariable<?> var, TypeVariable<?>[] declaredTypes) {
        if (param.getActualTypeArguments().length < 1) {
            return null;
        }
        for (int i = 0; i < declaredTypes.length; ++i) {
            if (param.getActualTypeArguments()[i] instanceof TypeVariable || !declaredTypes[i].getName().equals(var.getName())) continue;
            return (Class)param.getActualTypeArguments()[i];
        }
        return null;
    }
}

