/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.TableVersionBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.TableVersionPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class TableVersionSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, TableVersionBaseSQLProvider> TABLE_VERSION_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new TableVersionMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new TableVersionH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new TableVersionPostgreSQLProvider());

    public static TableVersionBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return TABLE_VERSION_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String insertTableVersion(@Param(value="tablePO") TablePO tablePO) {
        return TableVersionSQLProviderFactory.getProvider().insertTableVersion(tablePO);
    }

    public static String insertTableVersionOnDuplicateKeyUpdate(@Param(value="tablePO") TablePO tablePO) {
        return TableVersionSQLProviderFactory.getProvider().insertTableVersionOnDuplicateKeyUpdate(tablePO);
    }

    public static String softDeleteTableVersionByTableIdAndVersion(@Param(value="tableId") Long tableId, @Param(value="version") Long version) {
        return TableVersionSQLProviderFactory.getProvider().softDeleteTableVersionByTableIdAndVersion(tableId, version);
    }

    public static String deleteTableVersionByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return TableVersionSQLProviderFactory.getProvider().deleteTableVersionByLegacyTimeline(legacyTimeline, limit);
    }

    static class TableVersionMySQLProvider
    extends TableVersionBaseSQLProvider {
        TableVersionMySQLProvider() {
        }
    }

    static class TableVersionH2Provider
    extends TableVersionBaseSQLProvider {
        TableVersionH2Provider() {
        }
    }
}

