/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class JdbcUrlUtils {
    private static final List<String> UNSAFE_MYSQL_PARAMETERS = Arrays.asList("maxAllowedPacket", "autoDeserialize", "queryInterceptors", "statementInterceptors", "detectCustomCollations", "allowloadlocalinfile", "allowUrlInLocalInfile", "allowLoadLocalInfileInPath");
    private static final List<String> UNSAFE_POSTGRES_PARAMETERS = Arrays.asList("socketFactory", "socketFactoryArg", "sslfactory", "sslhostnameverifier", "sslpasswordcallback", "authenticationPluginClassName");

    private JdbcUrlUtils() {
    }

    public static void validateJdbcConfig(String driver, String url, Map<String, String> all) {
        Preconditions.checkArgument(StringUtils.isNotBlank(driver), "Driver class name can't be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank(url), "JDBC URL can't be blank");
        String lowerUrl = url.toLowerCase();
        String decodedUrl = JdbcUrlUtils.recursiveDecode(lowerUrl);
        if (decodedUrl.startsWith("jdbc:mysql")) {
            JdbcUrlUtils.checkUnsafeParameters(decodedUrl, all, UNSAFE_MYSQL_PARAMETERS, "MySQL");
        } else if (decodedUrl.startsWith("jdbc:mariadb")) {
            JdbcUrlUtils.checkUnsafeParameters(decodedUrl, all, UNSAFE_MYSQL_PARAMETERS, "MariaDB");
        } else if (decodedUrl.startsWith("jdbc:postgresql")) {
            JdbcUrlUtils.checkUnsafeParameters(decodedUrl, all, UNSAFE_POSTGRES_PARAMETERS, "PostgreSQL");
        }
    }

    private static void checkUnsafeParameters(String url, Map<String, String> config, List<String> unsafeParams, String dbType) {
        String lowerUrl = url.toLowerCase();
        for (String param : unsafeParams) {
            String lowerParam = param.toLowerCase();
            if (!lowerUrl.contains(lowerParam) && !JdbcUrlUtils.containsValueIgnoreCase(config, param)) continue;
            throw new GravitinoRuntimeException("Unsafe %s parameter '%s' detected in JDBC URL", dbType, param);
        }
    }

    private static String recursiveDecode(String url) {
        String prev;
        String decoded = url;
        int max = 5;
        do {
            prev = decoded;
            try {
                decoded = URLDecoder.decode(prev, "UTF-8");
            }
            catch (Exception e) {
                throw new GravitinoRuntimeException("Unable to decode JDBC URL");
            }
        } while (!prev.equals(decoded) && --max > 0);
        return decoded;
    }

    private static boolean containsValueIgnoreCase(Map<String, String> map, String value) {
        for (String keyValue : map.values()) {
            if (keyValue == null || !keyValue.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }
}

