/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.mover;

import org.apache.hadoop.hdfs.server.mover.Mover;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;

@Metrics(about="Mover metrics", context="dfs")
final class MoverMetrics {
    private final Mover mover;
    @Metric(value={"If mover is processing namespace."})
    private MutableGaugeInt processingNamespace;
    @Metric(value={"Number of blocks being scheduled."})
    private MutableCounterLong blocksScheduled;
    @Metric(value={"Number of files being processed."})
    private MutableCounterLong filesProcessed;

    private MoverMetrics(Mover m) {
        this.mover = m;
    }

    public static MoverMetrics create(Mover mover) {
        MoverMetrics m = new MoverMetrics(mover);
        return (MoverMetrics)DefaultMetricsSystem.instance().register(m.getName(), null, (Object)m);
    }

    String getName() {
        return "Mover-" + this.mover.getNnc().getBlockpoolID();
    }

    @Metric(value={"Bytes that already moved by mover."})
    public long getBytesMoved() {
        return this.mover.getNnc().getBytesMoved().get();
    }

    @Metric(value={"Number of blocks that successfully moved by mover."})
    public long getBlocksMoved() {
        return this.mover.getNnc().getBlocksMoved().get();
    }

    @Metric(value={"Number of blocks that failed moved by mover."})
    public long getBlocksFailed() {
        return this.mover.getNnc().getBlocksFailed().get();
    }

    void setProcessingNamespace(boolean processingNamespace) {
        this.processingNamespace.set(processingNamespace ? 1 : 0);
    }

    void incrBlocksScheduled() {
        this.blocksScheduled.incr();
    }

    void incrFilesProcessed() {
        this.filesProcessed.incr();
    }
}

