/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.quotas.DefaultOperationQuota;
import org.apache.hadoop.hbase.quotas.ExceedOperationQuota;
import org.apache.hadoop.hbase.quotas.NoopOperationQuota;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.RpcQuotaManager;
import org.apache.hadoop.hbase.quotas.RpcThrottleStorage;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.quotas.UserQuotaState;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.base.Suppliers;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RegionServerRpcQuotaManager
implements RpcQuotaManager,
ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(RegionServerRpcQuotaManager.class);
    private final RegionServerServices rsServices;
    private QuotaCache quotaCache = null;
    private volatile boolean rpcThrottleEnabled;
    private RpcThrottleStorage rpcThrottleStorage;
    private final Supplier<Double> requestsPerSecondSupplier;

    public RegionServerRpcQuotaManager(RegionServerServices rsServices) {
        this.rsServices = rsServices;
        this.rpcThrottleStorage = new RpcThrottleStorage(rsServices.getZooKeeper(), rsServices.getConfiguration());
        this.requestsPerSecondSupplier = Suppliers.memoizeWithExpiration(() -> rsServices.getMetrics().getRegionServerWrapper().getRequestsPerSecond(), 1L, TimeUnit.MINUTES);
    }

    public void start(RpcScheduler rpcScheduler) throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.rsServices.getConfiguration())) {
            LOG.info("Quota support disabled");
            return;
        }
        LOG.info("Initializing RPC quota support");
        this.quotaCache = new QuotaCache(this.rsServices);
        this.quotaCache.start();
        this.rpcThrottleEnabled = this.rpcThrottleStorage.isRpcThrottleEnabled();
        LOG.info("Start rpc quota manager and rpc throttle enabled is {}", (Object)this.rpcThrottleEnabled);
    }

    public void stop() {
        if (this.isQuotaEnabled()) {
            this.quotaCache.stop("shutdown");
        }
    }

    public void reload() {
        if (this.isQuotaEnabled()) {
            this.quotaCache.forceSynchronousCacheRefresh();
        }
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.reload();
    }

    protected boolean isRpcThrottleEnabled() {
        return this.rpcThrottleEnabled;
    }

    private boolean isQuotaEnabled() {
        return this.quotaCache != null;
    }

    public void switchRpcThrottle(boolean enable) throws IOException {
        if (this.isQuotaEnabled()) {
            if (this.rpcThrottleEnabled != enable) {
                boolean previousEnabled = this.rpcThrottleEnabled;
                this.rpcThrottleEnabled = this.rpcThrottleStorage.isRpcThrottleEnabled();
                LOG.info("Switch rpc throttle from {} to {}", (Object)previousEnabled, (Object)this.rpcThrottleEnabled);
            } else {
                LOG.warn("Skip switch rpc throttle because previous value {} is the same as current value {}", (Object)this.rpcThrottleEnabled, (Object)enable);
            }
        } else {
            LOG.warn("Skip switch rpc throttle to {} because rpc quota is disabled", (Object)enable);
        }
    }

    QuotaCache getQuotaCache() {
        return this.quotaCache;
    }

    public OperationQuota getQuota(UserGroupInformation ugi, TableName table, int blockSizeBytes) {
        if (this.isQuotaEnabled() && !table.isSystemTable() && this.isRpcThrottleEnabled()) {
            UserQuotaState userQuotaState = this.quotaCache.getUserQuotaState(ugi);
            QuotaLimiter userLimiter = userQuotaState.getTableLimiter(table);
            boolean useNoop = userLimiter.isBypass();
            if (userQuotaState.hasBypassGlobals()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("get quota for ugi=" + ugi + " table=" + table + " userLimiter=" + userLimiter);
                }
                if (!useNoop) {
                    return new DefaultOperationQuota(this.rsServices.getConfiguration(), blockSizeBytes, this.requestsPerSecondSupplier.get(), userLimiter);
                }
            } else {
                QuotaLimiter nsLimiter = this.quotaCache.getNamespaceLimiter(table.getNamespaceAsString());
                QuotaLimiter tableLimiter = this.quotaCache.getTableLimiter(table);
                QuotaLimiter rsLimiter = this.quotaCache.getRegionServerQuotaLimiter("all");
                useNoop &= tableLimiter.isBypass() && nsLimiter.isBypass() && rsLimiter.isBypass();
                boolean exceedThrottleQuotaEnabled = this.quotaCache.isExceedThrottleQuotaEnabled();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("get quota for ugi=" + ugi + " table=" + table + " userLimiter=" + userLimiter + " tableLimiter=" + tableLimiter + " nsLimiter=" + nsLimiter + " rsLimiter=" + rsLimiter + " exceedThrottleQuotaEnabled=" + exceedThrottleQuotaEnabled);
                }
                if (!useNoop) {
                    if (exceedThrottleQuotaEnabled) {
                        return new ExceedOperationQuota(this.rsServices.getConfiguration(), blockSizeBytes, (double)this.requestsPerSecondSupplier.get(), rsLimiter, new QuotaLimiter[]{userLimiter, tableLimiter, nsLimiter});
                    }
                    return new DefaultOperationQuota(this.rsServices.getConfiguration(), blockSizeBytes, this.requestsPerSecondSupplier.get(), userLimiter, tableLimiter, nsLimiter, rsLimiter);
                }
            }
        }
        return NoopOperationQuota.get();
    }

    @Override
    public OperationQuota checkScanQuota(Region region, ClientProtos.ScanRequest scanRequest, long maxScannerResultSize, long maxBlockBytesScanned, long prevBlockBytesScannedDifference) throws IOException, RpcThrottlingException {
        Optional<User> user = RpcServer.getRequestUser();
        UserGroupInformation ugi = user.isPresent() ? user.get().getUGI() : User.getCurrent().getUGI();
        TableDescriptor tableDescriptor = region.getTableDescriptor();
        TableName table = tableDescriptor.getTableName();
        OperationQuota quota = this.getQuota(ugi, table, region.getMinBlockSizeBytes());
        try {
            quota.checkScanQuota(scanRequest, maxScannerResultSize, maxBlockBytesScanned, prevBlockBytesScannedDifference);
        }
        catch (RpcThrottlingException e) {
            LOG.debug("Throttling exception for user=" + ugi.getUserName() + " table=" + table + " scan=" + scanRequest.getScannerId() + ": " + e.getMessage());
            this.rsServices.getMetrics().recordThrottleException(e.getType(), this.quotaCache.getQuotaUserName(ugi), table.getNameAsString());
            throw e;
        }
        return quota;
    }

    @Override
    public OperationQuota checkBatchQuota(Region region, OperationQuota.OperationType type) throws IOException, RpcThrottlingException {
        switch (type) {
            case GET: {
                return this.checkBatchQuota(region, 0, 1, false);
            }
            case MUTATE: {
                return this.checkBatchQuota(region, 1, 0, false);
            }
            case CHECK_AND_MUTATE: {
                return this.checkBatchQuota(region, 1, 1, true);
            }
        }
        throw new RuntimeException("Invalid operation type: " + (Object)((Object)type));
    }

    @Override
    public OperationQuota checkBatchQuota(Region region, List<ClientProtos.Action> actions, boolean hasCondition) throws IOException, RpcThrottlingException {
        int numWrites = 0;
        int numReads = 0;
        boolean isAtomic = false;
        for (ClientProtos.Action action : actions) {
            if (action.hasMutation()) {
                ++numWrites;
                OperationQuota.OperationType operationType = QuotaUtil.getQuotaOperationType(action, hasCondition);
                if (operationType != OperationQuota.OperationType.CHECK_AND_MUTATE) continue;
                ++numReads;
                isAtomic = true;
                continue;
            }
            if (!action.hasGet()) continue;
            ++numReads;
        }
        return this.checkBatchQuota(region, numWrites, numReads, isAtomic);
    }

    @Override
    public OperationQuota checkBatchQuota(Region region, int numWrites, int numReads, boolean isAtomic) throws IOException, RpcThrottlingException {
        Optional<User> user = RpcServer.getRequestUser();
        UserGroupInformation ugi = user.isPresent() ? user.get().getUGI() : User.getCurrent().getUGI();
        TableDescriptor tableDescriptor = region.getTableDescriptor();
        TableName table = tableDescriptor.getTableName();
        OperationQuota quota = this.getQuota(ugi, table, region.getMinBlockSizeBytes());
        try {
            quota.checkBatchQuota(numWrites, numReads, isAtomic);
        }
        catch (RpcThrottlingException e) {
            LOG.debug("Throttling exception for user=" + ugi.getUserName() + " table=" + table + " numWrites=" + numWrites + " numReads=" + numReads + ": " + e.getMessage());
            this.rsServices.getMetrics().recordThrottleException(e.getType(), this.quotaCache.getQuotaUserName(ugi), table.getNameAsString());
            throw e;
        }
        return quota;
    }
}

