/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourcesExceptionUtil;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.NodeResourceUpdaterPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDiscoverer;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.PerGpuDeviceInformation;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpuNodeResourceUpdateHandler
extends NodeResourceUpdaterPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(GpuNodeResourceUpdateHandler.class);
    private final GpuDiscoverer gpuDiscoverer;
    private Configuration conf;

    public GpuNodeResourceUpdateHandler(GpuDiscoverer gpuDiscoverer, Configuration conf) {
        this.gpuDiscoverer = gpuDiscoverer;
        this.conf = conf;
    }

    @Override
    public void updateConfiguredResource(Resource res) throws YarnException {
        LOG.info("Initializing configured GPU resources for the NodeManager.");
        List<GpuDevice> usableGpus = this.gpuDiscoverer.getGpusUsableByYarn();
        if (usableGpus == null || usableGpus.isEmpty()) {
            String message = "GPU is enabled, but could not find any usable GPUs on the NodeManager!";
            LOG.error(message);
            ResourcesExceptionUtil.throwIfNecessary(new YarnException(message), this.conf);
            return;
        }
        long nUsableGpus = usableGpus.size();
        Map configuredResourceTypes = ResourceUtils.getResourceTypes();
        if (!configuredResourceTypes.containsKey("yarn.io/gpu")) {
            LOG.warn("Found " + nUsableGpus + " usable GPUs, however " + "yarn.io/gpu" + " resource-type is not configured inside resource-types.xml, please configure it to enable GPU feature or remove " + "yarn.io/gpu" + " from " + "yarn.nodemanager.resource-plugins");
        }
        res.setResourceValue("yarn.io/gpu", nUsableGpus);
    }

    public float getAvgNodeGpuUtilization() throws Exception {
        List<PerGpuDeviceInformation> gpuList = this.gpuDiscoverer.getGpuDeviceInformation().getGpus();
        Float avgGpuUtilization = Float.valueOf(0.0f);
        if (gpuList != null && gpuList.size() != 0) {
            avgGpuUtilization = Float.valueOf(this.getTotalNodeGpuUtilization() / (float)gpuList.size());
        }
        return avgGpuUtilization.floatValue();
    }

    public float getTotalNodeGpuUtilization() throws Exception {
        List<PerGpuDeviceInformation> gpuList = this.gpuDiscoverer.getGpuDeviceInformation().getGpus();
        Float totalGpuUtilization = Float.valueOf(gpuList.stream().map(g -> g.getGpuUtilizations().getOverallGpuUtilization()).collect(Collectors.summingDouble(Float::floatValue)).floatValue());
        return totalGpuUtilization.floatValue();
    }
}

