/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.storefiletracker.MigrationStoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerBase;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, MediumTests.class})
public class TestMigrationStoreFileTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMigrationStoreFileTracker.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final TableDescriptor TD = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"file_based_tracker")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF)).build();
    private static final RegionInfo RI = RegionInfoBuilder.newBuilder((TableName)TD.getTableName()).build();
    @Rule
    public TestName name = new TestName();
    @Parameterized.Parameter(value=0)
    public StoreFileTrackerFactory.Trackers srcImpl;
    @Parameterized.Parameter(value=1)
    public StoreFileTrackerFactory.Trackers dstImpl;
    private HRegion region;
    private Path rootDir;
    private WAL wal;

    @Parameterized.Parameters(name="{index}: src={0}, dst={1}")
    public static List<Object[]> params() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (StoreFileTrackerFactory.Trackers src : StoreFileTrackerFactory.Trackers.values()) {
            for (StoreFileTrackerFactory.Trackers dst : StoreFileTrackerFactory.Trackers.values()) {
                if (src == StoreFileTrackerFactory.Trackers.MIGRATION || dst == StoreFileTrackerFactory.Trackers.MIGRATION || src.equals((Object)dst)) continue;
                params.add(new Object[]{src, dst});
            }
        }
        return params;
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
    }

    @Before
    public void setUp() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.store.file-tracker.migration.src.impl", this.srcImpl.name().toLowerCase());
        conf.set("hbase.store.file-tracker.migration.dst.impl", this.dstImpl.name().toLowerCase());
        this.rootDir = UTIL.getDataTestDir(this.name.getMethodName().replaceAll("[=:\\[ ]", "_"));
        this.wal = HBaseTestingUtility.createWal(conf, this.rootDir, RI);
    }

    @After
    public void tearDown() throws IOException {
        if (this.region != null) {
            this.region.close();
        }
        Closeables.close((Closeable)this.wal, (boolean)true);
        UTIL.cleanupTestDir();
    }

    private List<String> getStoreFiles() {
        return ((HStore)Iterables.getOnlyElement((Iterable)this.region.getStores())).getStorefiles().stream().map(s -> s.getFileInfo().getPath().getName()).collect(Collectors.toList());
    }

    private HRegion createRegion(Class<? extends StoreFileTrackerBase> trackerImplClass) throws IOException {
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setClass("hbase.store.file-tracker.impl", trackerImplClass, StoreFileTracker.class);
        return HRegion.createHRegion((RegionInfo)RI, (Path)this.rootDir, (Configuration)conf, (TableDescriptor)TD, (WAL)this.wal, (boolean)true);
    }

    private void reopenRegion(Class<? extends StoreFileTrackerBase> trackerImplClass) throws IOException {
        this.region.flush(true);
        List<String> before = this.getStoreFiles();
        this.region.close();
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setClass("hbase.store.file-tracker.impl", trackerImplClass, StoreFileTracker.class);
        this.region = HRegion.openHRegion((Path)this.rootDir, (RegionInfo)RI, (TableDescriptor)TD, (WAL)this.wal, (Configuration)conf);
        List<String> after = this.getStoreFiles();
        Assert.assertEquals((long)before.size(), (long)after.size());
        MatcherAssert.assertThat(after, (Matcher)CoreMatchers.hasItems((Object[])before.toArray(new String[0])));
    }

    private void putData(int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            this.region.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            if (i % 30 != 0) continue;
            this.region.flush(true);
        }
    }

    private void verifyData(int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            Result result = this.region.get(new Get(Bytes.toBytes((int)i)));
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(CF, CQ)));
        }
    }

    @Test
    public void testMigration() throws IOException {
        this.region = this.createRegion(this.srcImpl.clazz.asSubclass(StoreFileTrackerBase.class));
        this.putData(0, 100);
        this.verifyData(0, 100);
        this.reopenRegion(MigrationStoreFileTracker.class);
        this.verifyData(0, 100);
        this.region.compact(true);
        this.putData(100, 200);
        this.reopenRegion(this.dstImpl.clazz.asSubclass(StoreFileTrackerBase.class));
        this.verifyData(0, 200);
    }
}

