/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;

public abstract class AbstractSystemMetricsPublisher
extends CompositeService
implements SystemMetricsPublisher {
    private MultiThreadedDispatcher dispatcher;

    protected Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public AbstractSystemMetricsPublisher(String name) {
        super(name);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.dispatcher = new MultiThreadedDispatcher(this.getConfig().getInt("yarn.resourcemanager.system-metrics-publisher.dispatcher.pool-size", 10));
        this.dispatcher.setDrainEventsOnStop();
        this.addIfService((Object)this.dispatcher);
        super.serviceInit(conf);
    }

    @Override
    public void appLaunched(RMApp app, long launchTime) {
    }

    protected static abstract class TimelinePublishEvent
    extends AbstractEvent<SystemMetricsEventType> {
        private ApplicationId appId;

        public TimelinePublishEvent(SystemMetricsEventType type, ApplicationId appId) {
            super((Enum)type);
            this.appId = appId;
        }

        public ApplicationId getApplicationId() {
            return this.appId;
        }

        public int hashCode() {
            return this.appId.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TimelinePublishEvent)) {
                return false;
            }
            TimelinePublishEvent other = (TimelinePublishEvent)((Object)obj);
            return !(this.appId == null ? other.appId != null : (this.getType() == null ? other.getType() != null : !this.appId.equals((Object)other.appId) || !((SystemMetricsEventType)this.getType()).equals(other.getType())));
        }
    }

    protected static enum SystemMetricsEventType {
        PUBLISH_ENTITY,
        PUBLISH_APPLICATION_FINISHED_ENTITY;

    }

    public static class MultiThreadedDispatcher
    extends CompositeService
    implements Dispatcher {
        private List<AsyncDispatcher> dispatchers = new ArrayList<AsyncDispatcher>();

        public MultiThreadedDispatcher(int num) {
            super(MultiThreadedDispatcher.class.getName());
            for (int i = 0; i < num; ++i) {
                AsyncDispatcher dispatcher = this.createDispatcher();
                this.dispatchers.add(dispatcher);
                this.addIfService(dispatcher);
            }
        }

        public EventHandler<Event> getEventHandler() {
            return new CompositEventHandler();
        }

        public void register(Class<? extends Enum> eventType, EventHandler handler) {
            for (AsyncDispatcher dispatcher : this.dispatchers) {
                dispatcher.register(eventType, handler);
            }
        }

        public void setDrainEventsOnStop() {
            for (AsyncDispatcher dispatcher : this.dispatchers) {
                dispatcher.setDrainEventsOnStop();
            }
        }

        protected AsyncDispatcher createDispatcher() {
            return new AsyncDispatcher("RM Timeline dispatcher");
        }

        private class CompositEventHandler
        implements EventHandler<Event> {
            private CompositEventHandler() {
            }

            public void handle(Event event) {
                int index = (event.hashCode() & Integer.MAX_VALUE) % MultiThreadedDispatcher.this.dispatchers.size();
                ((AsyncDispatcher)MultiThreadedDispatcher.this.dispatchers.get(index)).getEventHandler().handle(event);
            }
        }
    }
}

