/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ReversedKeyValueHeap;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReversedStoreScanner
extends StoreScanner
implements KeyValueScanner {
    public ReversedStoreScanner(HStore store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
        super(store, scanInfo, scan, columns, readPt);
    }

    public ReversedStoreScanner(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, List<? extends KeyValueScanner> scanners) throws IOException {
        super(scan, scanInfo, columns, scanners);
    }

    @Override
    protected KeyValueHeap newKVHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator) throws IOException {
        return new ReversedKeyValueHeap(scanners, comparator);
    }

    @Override
    protected void seekScanners(List<? extends KeyValueScanner> scanners, Cell seekKey, boolean isLazy, boolean isParallelSeek) throws IOException {
        if (CellUtil.matchingRows((Cell)seekKey, (byte[])HConstants.EMPTY_START_ROW)) {
            for (KeyValueScanner keyValueScanner : scanners) {
                keyValueScanner.seekToLastRow();
            }
        } else {
            for (KeyValueScanner keyValueScanner : scanners) {
                keyValueScanner.backwardSeek(seekKey);
            }
        }
    }

    @Override
    protected boolean seekToNextRow(Cell kv) throws IOException {
        return this.seekToPreviousRow(kv);
    }

    @Override
    protected boolean seekAsDirection(Cell kv) throws IOException {
        return this.backwardSeek(kv);
    }

    @Override
    protected void checkScanOrder(Cell prevKV, Cell kv, CellComparator comparator) throws IOException {
        assert (prevKV == null || comparator == null || comparator.compareRows(kv, prevKV) < 0 || CellUtil.matchingRows((Cell)kv, (Cell)prevKV) && comparator.compare(kv, prevKV) >= 0) : "Key " + prevKV + " followed by a error order key " + kv + " in cf " + this.store + " in reversed scan";
    }

    @Override
    public boolean reseek(Cell kv) throws IOException {
        throw new IllegalStateException("reseek cannot be called on ReversedStoreScanner");
    }

    @Override
    public boolean seek(Cell key) throws IOException {
        throw new IllegalStateException("seek cannot be called on ReversedStoreScanner");
    }

    @Override
    public boolean seekToPreviousRow(Cell key) throws IOException {
        if (this.checkFlushed()) {
            this.reopenAfterFlush();
        }
        return this.heap.seekToPreviousRow(key);
    }

    @Override
    public boolean backwardSeek(Cell key) throws IOException {
        if (this.checkFlushed()) {
            this.reopenAfterFlush();
        }
        return this.heap.backwardSeek(key);
    }
}

