/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.model.StorageClusterVersionModel;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.core.CacheControl;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Response;
import org.apache.hbase.thirdparty.javax.ws.rs.core.UriInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StorageClusterVersionResource
extends ResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(StorageClusterVersionResource.class);
    static CacheControl cacheControl = new CacheControl();

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            StorageClusterVersionModel model = new StorageClusterVersionModel();
            model.setVersion(this.servlet.getAdmin().getClusterMetrics(EnumSet.of(ClusterMetrics.Option.HBASE_VERSION)).getHBaseVersion());
            Response.ResponseBuilder response = Response.ok((Object)model);
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

