/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.errorhandling;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionListener;
import org.apache.hadoop.hbase.errorhandling.TimeoutExceptionInjector;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestTimeoutExceptionInjector {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTimeoutExceptionInjector.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestTimeoutExceptionInjector.class);

    @Test
    public void testTimerTrigger() {
        long time = 10000000L;
        ForeignExceptionListener listener = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(listener, 10000000L);
        timer.start();
        timer.trigger();
        ((ForeignExceptionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).receive((ForeignException)((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testTimerPassesOnErrorInfo() {
        long time = 1000000L;
        ForeignExceptionListener listener = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(listener, 1000000L);
        timer.start();
        timer.trigger();
        ((ForeignExceptionListener)Mockito.verify((Object)listener)).receive((ForeignException)((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testStartAfterComplete() throws InterruptedException {
        long time = 10L;
        ForeignExceptionListener listener = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(listener, 10L);
        timer.complete();
        try {
            timer.start();
            Assert.fail((String)"Timer should fail to start after complete.");
        }
        catch (IllegalStateException e) {
            LOG.debug("Correctly failed timer: " + e.getMessage());
        }
        Thread.sleep(11L);
        Mockito.verifyNoInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testStartAfterTrigger() throws InterruptedException {
        long time = 10L;
        ForeignExceptionListener listener = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(listener, 10L);
        timer.trigger();
        try {
            timer.start();
            Assert.fail((String)"Timer should fail to start after complete.");
        }
        catch (IllegalStateException e) {
            LOG.debug("Correctly failed timer: " + e.getMessage());
        }
        Thread.sleep(20L);
        ((ForeignExceptionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).receive((ForeignException)((Object)ArgumentMatchers.any()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }
}

