/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestMemorySizeUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMemorySizeUtil.class);
    private Configuration conf;

    @Before
    public void setup() {
        this.conf = new Configuration();
    }

    @Test
    public void testValidateRegionServerHeapMemoryAllocation() {
        this.conf.setFloat("hbase.regionserver.global.memstore.size", 0.4f);
        this.conf.setFloat("hfile.block.cache.size", 0.4f);
        Assert.assertEquals((float)0.2f, (float)0.2f, (float)0.0f);
        MemorySizeUtil.validateRegionServerHeapMemoryAllocation((Configuration)this.conf);
        this.conf.setFloat("hbase.regionserver.global.memstore.size", 0.5f);
        Assert.assertThrows(RuntimeException.class, () -> MemorySizeUtil.validateRegionServerHeapMemoryAllocation((Configuration)this.conf));
        this.conf.setFloat("hbase.regionserver.global.memstore.size", 0.5f);
        this.conf.setFloat("hfile.block.cache.size", 0.5f);
        this.conf.setLong("hbase.regionserver.free.heap.min.memory.size", 0L);
        MemorySizeUtil.validateRegionServerHeapMemoryAllocation((Configuration)this.conf);
        this.conf.setLong("hbase.regionserver.free.heap.min.memory.size", -1024L);
        this.conf.setFloat("hbase.regionserver.global.memstore.size", 0.4f);
        this.conf.setFloat("hfile.block.cache.size", 0.4f);
        MemorySizeUtil.validateRegionServerHeapMemoryAllocation((Configuration)this.conf);
        this.conf.setFloat("hbase.regionserver.global.memstore.size", 0.41f);
        Assert.assertThrows(RuntimeException.class, () -> MemorySizeUtil.validateRegionServerHeapMemoryAllocation((Configuration)this.conf));
    }

    @Test
    public void testGetRegionServerMinFreeHeapFraction() {
        this.conf.set("hbase.regionserver.free.heap.min.memory.size", "");
        float minFreeHeapFraction = MemorySizeUtil.getRegionServerMinFreeHeapFraction((Configuration)this.conf);
        Assert.assertEquals((float)0.2f, (float)minFreeHeapFraction, (float)0.0f);
        this.conf.set("hbase.regionserver.free.heap.min.memory.size", "0");
        minFreeHeapFraction = MemorySizeUtil.getRegionServerMinFreeHeapFraction((Configuration)this.conf);
        Assert.assertEquals((float)0.0f, (float)minFreeHeapFraction, (float)0.0f);
    }
}

