/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.balance.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.bifromq.basekv.balance.impl.RuleBasedPlacementBalancer;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.proto.SplitHint;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.EffectiveRoute;
import org.apache.bifromq.basekv.utils.RangeLeader;

public class RangeSplitBalancer
extends RuleBasedPlacementBalancer {
    public static final String LOAD_RULE_CPU_USAGE_LIMIT = "maxCpuUsagePerRange";
    public static final String LOAD_RULE_MAX_IO_DENSITY_PER_RANGE = "maxIODensityPerRange";
    public static final String LOAD_RULE_IO_NANOS_LIMIT_PER_RANGE = "ioNanosLimitPerRange";
    public static final String LOAD_RULE_MAX_RANGES_PER_STORE = "maxRangesPerStore";
    private static final String LOAD_TYPE_IO_DENSITY = "ioDensity";
    private static final String LOAD_TYPE_IO_LATENCY_NANOS = "ioLatencyNanos";
    private static final String LOAD_TYPE_CPU_USAGE = "cpu.usage";
    private final String hintType;
    private final Struct defaultLoadRules;

    public RangeSplitBalancer(String clusterId, String localStoreId, String hintType, int maxRangesPerStore, double cpuUsageLimit, int maxIoDensity, long ioNanoLimit) {
        super(clusterId, localStoreId);
        this.hintType = hintType;
        this.defaultLoadRules = Struct.newBuilder().putFields(LOAD_RULE_CPU_USAGE_LIMIT, Value.newBuilder().setNumberValue(cpuUsageLimit).build()).putFields(LOAD_RULE_MAX_IO_DENSITY_PER_RANGE, Value.newBuilder().setNumberValue((double)maxIoDensity).build()).putFields(LOAD_RULE_IO_NANOS_LIMIT_PER_RANGE, Value.newBuilder().setNumberValue((double)ioNanoLimit).build()).putFields(LOAD_RULE_MAX_RANGES_PER_STORE, Value.newBuilder().setNumberValue((double)maxRangesPerStore).build()).build();
    }

    public Struct initialLoadRules() {
        return this.defaultLoadRules;
    }

    @Override
    public boolean validate(Struct loadRules) {
        Value cpuUsageLimit = (Value)loadRules.getFieldsMap().get(LOAD_RULE_CPU_USAGE_LIMIT);
        if (cpuUsageLimit == null || !cpuUsageLimit.hasNumberValue() || cpuUsageLimit.getNumberValue() < 0.0 || cpuUsageLimit.getNumberValue() > 1.0) {
            return false;
        }
        Value maxIODensityPerRange = (Value)loadRules.getFieldsMap().get(LOAD_RULE_MAX_IO_DENSITY_PER_RANGE);
        if (maxIODensityPerRange == null || !maxIODensityPerRange.hasNumberValue() || maxIODensityPerRange.getNumberValue() < 0.0) {
            return false;
        }
        Value maxIONanosPerRange = (Value)loadRules.getFieldsMap().get(LOAD_RULE_IO_NANOS_LIMIT_PER_RANGE);
        if (maxIONanosPerRange == null || !maxIONanosPerRange.hasNumberValue() || maxIONanosPerRange.getNumberValue() < 0.0) {
            return false;
        }
        Value maxRangesPerStore = (Value)loadRules.getFieldsMap().get(LOAD_RULE_MAX_RANGES_PER_STORE);
        return maxRangesPerStore != null && maxRangesPerStore.hasNumberValue() && maxRangesPerStore.getNumberValue() > 0.0;
    }

    @Override
    protected Map<Boundary, ClusterConfig> doGenerate(Struct loadRules, Map<String, KVRangeStoreDescriptor> landscape, EffectiveRoute effectiveRoute) {
        double cpuUsageLimit = ((Value)loadRules.getFieldsMap().get(LOAD_RULE_CPU_USAGE_LIMIT)).getNumberValue();
        double maxRangesPerStore = ((Value)loadRules.getFieldsMap().get(LOAD_RULE_MAX_RANGES_PER_STORE)).getNumberValue();
        double maxIODensityPerRange = ((Value)loadRules.getFieldsMap().get(LOAD_RULE_MAX_IO_DENSITY_PER_RANGE)).getNumberValue();
        double ioLatencyLimitPerRange = ((Value)loadRules.getFieldsMap().get(LOAD_RULE_IO_NANOS_LIMIT_PER_RANGE)).getNumberValue();
        HashMap<Boundary, ClusterConfig> expectedRangeLayout = new HashMap<Boundary, ClusterConfig>();
        for (Map.Entry entry : effectiveRoute.leaderRanges().entrySet()) {
            Boundary boundary = (Boundary)entry.getKey();
            RangeLeader rangeLeader = (RangeLeader)entry.getValue();
            KVRangeDescriptor rangeDescriptor = rangeLeader.descriptor();
            KVRangeStoreDescriptor storeDescriptor = landscape.get(rangeLeader.storeId());
            ClusterConfig clusterConfig = rangeDescriptor.getConfig();
            if (this.containsDeadMember(clusterConfig, landscape.keySet())) {
                return Collections.emptyMap();
            }
            Optional<SplitHint> splitHintOpt = rangeDescriptor.getHintsList().stream().filter(h -> h.getType().equals(this.hintType)).findFirst();
            if (splitHintOpt.isPresent()) {
                SplitHint splitHint = splitHintOpt.get();
                double cpuUsage = (Double)storeDescriptor.getStatisticsMap().get(LOAD_TYPE_CPU_USAGE);
                double ioDensity = splitHint.getLoadOrDefault(LOAD_TYPE_IO_DENSITY, 0.0);
                double ioLatencyNanos = splitHint.getLoadOrDefault(LOAD_TYPE_IO_LATENCY_NANOS, 0.0);
                if (clusterConfig.getNextVotersList().isEmpty() && clusterConfig.getNextLearnersList().isEmpty() && cpuUsage < cpuUsageLimit && ioLatencyNanos < ioLatencyLimitPerRange && ioDensity > maxIODensityPerRange && (double)storeDescriptor.getRangesList().size() < maxRangesPerStore && splitHint.hasSplitKey()) {
                    if (BoundaryUtil.compareStartKey((ByteString)BoundaryUtil.startKey((Boundary)boundary), (ByteString)splitHint.getSplitKey()) < 0 && BoundaryUtil.compareEndKeys((ByteString)splitHint.getSplitKey(), (ByteString)BoundaryUtil.endKey((Boundary)boundary)) < 0) {
                        expectedRangeLayout.put(boundary.toBuilder().setEndKey(splitHint.getSplitKey()).build(), clusterConfig);
                        expectedRangeLayout.put(boundary.toBuilder().setStartKey(splitHint.getSplitKey()).build(), clusterConfig);
                        continue;
                    }
                    this.log.warn("Invalid split key in hint: {}, range: {}", (Object)splitHint.getSplitKey(), (Object)boundary);
                    expectedRangeLayout.put(boundary, rangeDescriptor.getConfig());
                    continue;
                }
                expectedRangeLayout.put(boundary, rangeDescriptor.getConfig());
                continue;
            }
            expectedRangeLayout.put(boundary, rangeDescriptor.getConfig());
        }
        return expectedRangeLayout;
    }

    private boolean containsDeadMember(ClusterConfig clusterConfig, Set<String> live) {
        HashSet members = new HashSet();
        members.addAll(clusterConfig.getVotersList());
        members.addAll(clusterConfig.getLearnersList());
        members.addAll(clusterConfig.getNextVotersList());
        members.addAll(clusterConfig.getNextLearnersList());
        return members.stream().anyMatch(m -> !live.contains(m));
    }
}

