/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.bifromq.basekv.localengine.IKVSpaceMigratableWriter;
import org.apache.bifromq.basekv.localengine.IRestoreSession;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpochHandle;
import org.apache.bifromq.basekv.localengine.rocksdb.IWriteStatsRecorder;
import org.apache.bifromq.basekv.localengine.rocksdb.IteratorOptions;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBCPableKVSpace;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVEngine;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBSnapshot;
import org.apache.bifromq.basekv.proto.Boundary;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;

class RocksDBKVSpaceMigratableWriter
extends RocksDBKVSpaceWriter
implements IKVSpaceMigratableWriter {
    RocksDBKVSpaceMigratableWriter(String id, IRocksDBKVSpaceEpochHandle dbHandle, RocksDBKVEngine<?> engine, WriteOptions writeOptions, ISyncContext syncContext, IWriteStatsRecorder.IRecorder writeStatsRecorder, Consumer<Map<ByteString, ByteString>> afterWrite, KVSpaceOpMeters opMeters, Logger logger) {
        super(id, dbHandle, engine, writeOptions, syncContext, writeStatsRecorder, afterWrite, opMeters, logger);
    }

    public IRestoreSession migrateTo(String targetSpaceId, Boundary boundary) {
        try {
            RocksDBCPableKVSpace targetKVSpace = (RocksDBCPableKVSpace)this.engine.createIfMissing(targetSpaceId);
            IRestoreSession targetSpaceRestoreSession = targetKVSpace.startRestore((count, bytes) -> this.logger.debug("Migrate {} kv to space[{}] from space[{}]: startKey={}, endKey={}", new Object[]{count, targetSpaceId, this.id, boundary.getStartKey().toStringUtf8(), boundary.getEndKey().toStringUtf8()}));
            try (RocksDBKVSpaceIterator itr = new RocksDBKVSpaceIterator(new RocksDBSnapshot(this.dbHandle, null), boundary, new IteratorOptions(false, 52428L));){
                itr.seekToFirst();
                while (itr.isValid()) {
                    targetSpaceRestoreSession.put(itr.key(), itr.value());
                    itr.next();
                }
            }
            this.helper.clear(this.dbHandle.cf(), boundary);
            return targetSpaceRestoreSession;
        }
        catch (Throwable e) {
            throw new KVEngineException("Delete range in batch failed", e);
        }
    }
}

