/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.fasterxml.jackson.databind.node.ArrayNode;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.handler.AbstractTrafficRulesHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.apiserver.http.handler.utils.JSONUtils;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficGovernor;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;

@Path(value="/service/traffic")
final class UnsetTrafficRulesHandler
extends AbstractTrafficRulesHandler
implements IHTTPRequestHandler {
    UnsetTrafficRulesHandler(IRPCServiceTrafficService trafficService) {
        super(trafficService);
    }

    @Override
    @DELETE
    @Operation(summary="Unset the traffic rules of a service")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="service_name", in=ParameterIn.HEADER, required=true, description="the service name", schema=@Schema(implementation=String.class))})
    @RequestBody(content={@Content(mediaType="application/json", schema=@Schema(implementation=String[].class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="400", description="Bad Request")})
    @Hidden
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) FullHttpRequest req) {
        String serviceName = HeaderUtils.getHeader(Headers.HEADER_SERVICE_NAME, (HttpRequest)req, true);
        if (!this.isTrafficGovernable(serviceName)) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((byte[])("Service not found: " + serviceName).getBytes())));
        }
        IRPCServiceTrafficGovernor governor = (IRPCServiceTrafficGovernor)this.governorMap.get(serviceName);
        if (governor == null) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((byte[])(serviceName + " not found").getBytes())));
        }
        HashSet trafficRules = new HashSet();
        try {
            ArrayNode tdObject = (ArrayNode)JSONUtils.MAPPER.readTree(req.content().toString(CharsetUtil.UTF_8));
            tdObject.forEach(node -> trafficRules.add(node.asText()));
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, Unpooled.copiedBuffer((byte[])e.getMessage().getBytes())));
        }
        return CompletableFuture.allOf((CompletableFuture[])trafficRules.stream().map(arg_0 -> ((IRPCServiceTrafficGovernor)governor).unsetTrafficRules(arg_0)).toArray(CompletableFuture[]::new)).thenApply(trafficDirective -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER));
    }
}

